/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.oauth2.logic;

import cn.dev33.satoken.SaManager;
import cn.dev33.satoken.context.model.SaRequest;
import cn.dev33.satoken.oauth2.SaOAuth2Manager;
import cn.dev33.satoken.oauth2.exception.SaOAuth2Exception;
import cn.dev33.satoken.oauth2.logic.SaOAuth2Consts;
import cn.dev33.satoken.oauth2.model.AccessTokenModel;
import cn.dev33.satoken.oauth2.model.ClientTokenModel;
import cn.dev33.satoken.oauth2.model.CodeModel;
import cn.dev33.satoken.oauth2.model.RefreshTokenModel;
import cn.dev33.satoken.oauth2.model.RequestAuthModel;
import cn.dev33.satoken.oauth2.model.SaClientModel;
import cn.dev33.satoken.util.SaFoxUtil;
import java.util.List;

public class SaOAuth2Template {
    public SaClientModel getClientModel(String clientId) {
        return null;
    }

    public String getOpenid(String clientId, Object loginId) {
        return null;
    }

    public SaClientModel checkClientModel(String clientId) {
        SaClientModel clientModel = this.getClientModel(clientId);
        if (clientModel == null) {
            throw new SaOAuth2Exception("\u65e0\u6548client_id: " + clientId);
        }
        return clientModel;
    }

    public AccessTokenModel checkAccessToken(String accessToken) {
        AccessTokenModel at = this.getAccessToken(accessToken);
        SaOAuth2Exception.throwBy(at == null, "\u65e0\u6548access_token\uff1a" + accessToken);
        return at;
    }

    public ClientTokenModel checkClientToken(String clientToken) {
        ClientTokenModel ct = this.getClientToken(clientToken);
        SaOAuth2Exception.throwBy(ct == null, "\u65e0\u6548\uff1aclient_token" + ct);
        return ct;
    }

    public Object getLoginIdByAccessToken(String accessToken) {
        return this.checkAccessToken((String)accessToken).loginId;
    }

    public void checkScope(String accessToken, String ... scopes) {
        if (scopes == null || scopes.length == 0) {
            return;
        }
        AccessTokenModel at = this.checkAccessToken(accessToken);
        List scopeList = SaFoxUtil.convertStringToList((String)at.scope);
        for (String scope : scopes) {
            SaOAuth2Exception.throwBy(!scopeList.contains(scope), "\u8be5 Access-Token \u4e0d\u5177\u5907 Scope\uff1a" + scope);
        }
    }

    public RequestAuthModel generateRequestAuth(SaRequest req, Object loginId) {
        RequestAuthModel ra = new RequestAuthModel();
        ra.clientId = req.getParamNotNull(SaOAuth2Consts.Param.client_id);
        ra.responseType = req.getParamNotNull(SaOAuth2Consts.Param.response_type);
        ra.redirectUri = req.getParamNotNull(SaOAuth2Consts.Param.redirect_uri);
        ra.state = req.getParam(SaOAuth2Consts.Param.state);
        ra.scope = req.getParam(SaOAuth2Consts.Param.scope, "");
        ra.loginId = loginId;
        return ra;
    }

    public CodeModel generateCode(RequestAuthModel ra) {
        this.deleteCode(this.getCodeValue(ra.clientId, ra.loginId));
        String code = this.randomCode(ra.clientId, ra.loginId, ra.scope);
        CodeModel cm = new CodeModel(code, ra.clientId, ra.scope, ra.loginId, ra.redirectUri);
        this.saveCode(cm);
        this.saveCodeIndex(cm);
        return cm;
    }

    public AccessTokenModel generateAccessToken(String code) {
        CodeModel cm = this.getCode(code);
        SaOAuth2Exception.throwBy(cm == null, "\u65e0\u6548code");
        this.deleteAccessToken(this.getAccessTokenValue(cm.clientId, cm.loginId));
        this.deleteRefreshToken(this.getRefreshTokenValue(cm.clientId, cm.loginId));
        AccessTokenModel at = this.converCodeToAccessToken(cm);
        RefreshTokenModel rt = this.converAccessTokenToRefreshToken(at);
        at.refreshToken = rt.refreshToken;
        at.refreshExpiresTime = rt.expiresTime;
        this.saveAccessToken(at);
        this.saveAccessTokenIndex(at);
        this.saveRefreshToken(rt);
        this.saveRefreshTokenIndex(rt);
        this.deleteCode(code);
        this.deleteCodeIndex(cm.clientId, cm.loginId);
        return at;
    }

    public AccessTokenModel refreshAccessToken(String refreshToken) {
        RefreshTokenModel rt = this.getRefreshToken(refreshToken);
        SaOAuth2Exception.throwBy(rt == null, "\u65e0\u6548refresh_token: " + refreshToken);
        if (SaOAuth2Manager.getConfig().getIsNewRefresh().booleanValue()) {
            this.deleteRefreshToken(rt.refreshToken);
            rt = this.converRefreshTokenToRefreshToken(rt);
            this.saveRefreshToken(rt);
            this.saveRefreshTokenIndex(rt);
        }
        this.deleteAccessToken(this.getAccessTokenValue(rt.clientId, rt.loginId));
        AccessTokenModel at = this.converRefreshTokenToAccessToken(rt);
        this.saveAccessToken(at);
        this.saveAccessTokenIndex(at);
        return at;
    }

    public AccessTokenModel generateAccessToken(RequestAuthModel ra, boolean isCreateRt) {
        this.deleteAccessToken(this.getAccessTokenValue(ra.clientId, ra.loginId));
        if (isCreateRt) {
            this.deleteRefreshToken(this.getRefreshTokenValue(ra.clientId, ra.loginId));
        }
        String newAtValue = this.randomAccessToken(ra.clientId, ra.loginId, ra.scope);
        AccessTokenModel at = new AccessTokenModel(newAtValue, ra.clientId, ra.loginId, ra.scope);
        at.openid = this.getOpenid(ra.clientId, ra.loginId);
        at.expiresTime = System.currentTimeMillis() + SaOAuth2Manager.getConfig().getAccessTokenTimeout() * 1000L;
        if (isCreateRt) {
            RefreshTokenModel rt = this.converAccessTokenToRefreshToken(at);
            this.saveRefreshToken(rt);
            this.saveRefreshTokenIndex(rt);
        }
        this.saveAccessToken(at);
        this.saveAccessTokenIndex(at);
        return at;
    }

    public ClientTokenModel generateClientToken(String clientId, String scope) {
        this.deleteClientToken(this.getPastTokenValue(clientId));
        String ctValue = this.getClientTokenValue(clientId);
        this.savePastTokenIndex(this.getClientToken(ctValue));
        ClientTokenModel ct = new ClientTokenModel(this.randomClientToken(clientId, scope), clientId, scope);
        ct.expiresTime = System.currentTimeMillis() + SaOAuth2Manager.getConfig().getClientTokenTimeout() * 1000L;
        this.saveClientToken(ct);
        this.saveClientTokenIndex(ct);
        return ct;
    }

    public String buildRedirectUri(String redirectUri, String code, String state) {
        String url = SaFoxUtil.joinParam((String)redirectUri, (String)SaOAuth2Consts.Param.code, (Object)code);
        if (!SaFoxUtil.isEmpty((Object)state)) {
            url = SaFoxUtil.joinParam((String)url, (String)SaOAuth2Consts.Param.state, (Object)state);
        }
        return url;
    }

    public String buildImplicitRedirectUri(String redirectUri, String token, String state) {
        String url = SaFoxUtil.joinSharpParam((String)redirectUri, (String)SaOAuth2Consts.Param.token, (Object)token);
        if (!SaFoxUtil.isEmpty((Object)state)) {
            url = SaFoxUtil.joinSharpParam((String)url, (String)SaOAuth2Consts.Param.state, (Object)state);
        }
        return url;
    }

    public void revokeAccessToken(String accessToken) {
        AccessTokenModel at = this.getAccessToken(accessToken);
        if (at == null) {
            return;
        }
        this.deleteAccessToken(accessToken);
        this.deleteAccessTokenIndex(at.clientId, at.accessToken);
        String refreshToken = this.getRefreshTokenValue(at.clientId, at.loginId);
        this.deleteRefreshToken(refreshToken);
        this.deleteRefreshTokenIndex(at.clientId, at.loginId);
    }

    public boolean isGrant(Object loginId, String clientId, String scope) {
        List grantScopeList = SaFoxUtil.convertStringToList((String)this.getGrantScope(clientId, loginId));
        List scopeList = SaFoxUtil.convertStringToList((String)scope);
        return scopeList.size() == 0 || grantScopeList.containsAll(scopeList);
    }

    public void checkContract(String clientId, String scope) {
        List scopelist;
        List clientScopeList = SaFoxUtil.convertStringToList((String)this.checkClientModel((String)clientId).contractScope);
        if (!clientScopeList.containsAll(scopelist = SaFoxUtil.convertStringToList((String)scope))) {
            throw new SaOAuth2Exception("\u8bf7\u6c42\u7684Scope\u6682\u672a\u7b7e\u7ea6");
        }
    }

    public void checkRightUrl(String clientId, String url) {
        if (!SaFoxUtil.isUrl((String)url)) {
            throw new SaOAuth2Exception("\u65e0\u6548redirect_url\uff1a" + url);
        }
        int qIndex = url.indexOf("?");
        if (qIndex != -1) {
            url = url.substring(0, qIndex);
        }
        List allowList = SaFoxUtil.convertStringToList((String)this.checkClientModel((String)clientId).allowUrl);
        if (!SaManager.getSaTokenAction().hasElement(allowList, url)) {
            throw new SaOAuth2Exception("\u975e\u6cd5redirect_url\uff1a" + url);
        }
    }

    public SaClientModel checkClientSecret(String clientId, String clientSecret) {
        SaClientModel cm = this.checkClientModel(clientId);
        SaOAuth2Exception.throwBy(cm.clientSecret == null || !cm.clientSecret.equals(clientSecret), "\u65e0\u6548client_secret: " + clientSecret);
        return cm;
    }

    public CodeModel checkGainTokenParam(String code, String clientId, String clientSecret, String redirectUri) {
        CodeModel cm = this.getCode(code);
        SaOAuth2Exception.throwBy(cm == null, "\u65e0\u6548code: " + code);
        SaOAuth2Exception.throwBy(!cm.clientId.equals(clientId), "\u65e0\u6548client_id: " + clientId);
        String dbSecret = this.checkClientModel((String)clientId).clientSecret;
        SaOAuth2Exception.throwBy(dbSecret == null || !dbSecret.equals(clientSecret), "\u65e0\u6548client_secret: " + clientSecret);
        if (!SaFoxUtil.isEmpty((Object)redirectUri)) {
            SaOAuth2Exception.throwBy(!redirectUri.equals(cm.redirectUri), "\u65e0\u6548redirect_uri: " + redirectUri);
        }
        return cm;
    }

    public RefreshTokenModel checkRefreshTokenParam(String clientId, String clientSecret, String refreshToken) {
        RefreshTokenModel rt = this.getRefreshToken(refreshToken);
        SaOAuth2Exception.throwBy(rt == null, "\u65e0\u6548refresh_token: " + refreshToken);
        SaOAuth2Exception.throwBy(!rt.clientId.equals(clientId), "\u65e0\u6548client_id: " + clientId);
        String dbSecret = this.checkClientModel((String)clientId).clientSecret;
        SaOAuth2Exception.throwBy(dbSecret == null || !dbSecret.equals(clientSecret), "\u65e0\u6548client_secret: " + clientSecret);
        return rt;
    }

    public AccessTokenModel checkAccessTokenParam(String clientId, String clientSecret, String accessToken) {
        AccessTokenModel at = this.checkAccessToken(accessToken);
        SaOAuth2Exception.throwBy(!at.clientId.equals(clientId), "\u65e0\u6548client_id\uff1a" + clientId);
        this.checkClientSecret(clientId, clientSecret);
        return at;
    }

    public AccessTokenModel converCodeToAccessToken(CodeModel cm) {
        AccessTokenModel at = new AccessTokenModel();
        at.accessToken = this.randomAccessToken(cm.clientId, cm.loginId, cm.scope);
        at.clientId = cm.clientId;
        at.loginId = cm.loginId;
        at.scope = cm.scope;
        at.openid = this.getOpenid(cm.clientId, cm.loginId);
        at.expiresTime = System.currentTimeMillis() + SaOAuth2Manager.getConfig().getAccessTokenTimeout() * 1000L;
        return at;
    }

    public RefreshTokenModel converAccessTokenToRefreshToken(AccessTokenModel at) {
        RefreshTokenModel rt = new RefreshTokenModel();
        rt.refreshToken = this.randomRefreshToken(at.clientId, at.loginId, at.scope);
        rt.clientId = at.clientId;
        rt.loginId = at.loginId;
        rt.scope = at.scope;
        rt.openid = at.openid;
        rt.expiresTime = System.currentTimeMillis() + SaOAuth2Manager.getConfig().getRefreshTokenTimeout() * 1000L;
        at.refreshToken = rt.refreshToken;
        at.refreshExpiresTime = rt.expiresTime;
        return rt;
    }

    public AccessTokenModel converRefreshTokenToAccessToken(RefreshTokenModel rt) {
        AccessTokenModel at = new AccessTokenModel();
        at.accessToken = this.randomAccessToken(rt.clientId, rt.loginId, rt.scope);
        at.refreshToken = rt.refreshToken;
        at.clientId = rt.clientId;
        at.loginId = rt.loginId;
        at.scope = rt.scope;
        at.openid = rt.openid;
        at.expiresTime = System.currentTimeMillis() + SaOAuth2Manager.getConfig().getAccessTokenTimeout() * 1000L;
        at.refreshExpiresTime = rt.expiresTime;
        return at;
    }

    public RefreshTokenModel converRefreshTokenToRefreshToken(RefreshTokenModel rt) {
        RefreshTokenModel newRt = new RefreshTokenModel();
        newRt.refreshToken = this.randomRefreshToken(rt.clientId, rt.loginId, rt.scope);
        newRt.expiresTime = System.currentTimeMillis() + SaOAuth2Manager.getConfig().getRefreshTokenTimeout() * 1000L;
        newRt.clientId = rt.clientId;
        newRt.scope = rt.scope;
        newRt.loginId = rt.loginId;
        newRt.openid = rt.openid;
        return newRt;
    }

    public void saveCode(CodeModel c) {
        if (c == null) {
            return;
        }
        SaManager.getSaTokenDao().setObject(this.splicingCodeSaveKey(c.code), (Object)c, SaOAuth2Manager.getConfig().getCodeTimeout());
    }

    public void saveCodeIndex(CodeModel c) {
        if (c == null) {
            return;
        }
        SaManager.getSaTokenDao().set(this.splicingCodeIndexKey(c.clientId, c.loginId), c.code, SaOAuth2Manager.getConfig().getCodeTimeout());
    }

    public void saveAccessToken(AccessTokenModel at) {
        if (at == null) {
            return;
        }
        SaManager.getSaTokenDao().setObject(this.splicingAccessTokenSaveKey(at.accessToken), (Object)at, at.getExpiresIn());
    }

    public void saveAccessTokenIndex(AccessTokenModel at) {
        if (at == null) {
            return;
        }
        SaManager.getSaTokenDao().set(this.splicingAccessTokenIndexKey(at.clientId, at.loginId), at.accessToken, at.getExpiresIn());
    }

    public void saveRefreshToken(RefreshTokenModel rt) {
        if (rt == null) {
            return;
        }
        SaManager.getSaTokenDao().setObject(this.splicingRefreshTokenSaveKey(rt.refreshToken), (Object)rt, rt.getExpiresIn());
    }

    public void saveRefreshTokenIndex(RefreshTokenModel rt) {
        if (rt == null) {
            return;
        }
        SaManager.getSaTokenDao().set(this.splicingRefreshTokenIndexKey(rt.clientId, rt.loginId), rt.refreshToken, rt.getExpiresIn());
    }

    public void saveClientToken(ClientTokenModel ct) {
        if (ct == null) {
            return;
        }
        SaManager.getSaTokenDao().setObject(this.splicingClientTokenSaveKey(ct.clientToken), (Object)ct, ct.getExpiresIn());
    }

    public void saveClientTokenIndex(ClientTokenModel ct) {
        if (ct == null) {
            return;
        }
        SaManager.getSaTokenDao().set(this.splicingClientTokenIndexKey(ct.clientId), ct.clientToken, ct.getExpiresIn());
    }

    public void savePastTokenIndex(ClientTokenModel ct) {
        if (ct == null) {
            return;
        }
        SaManager.getSaTokenDao().set(this.splicingPastTokenIndexKey(ct.clientId), ct.clientToken, ct.getExpiresIn());
    }

    public void saveGrantScope(String clientId, Object loginId, String scope) {
        if (!SaFoxUtil.isEmpty((Object)scope)) {
            long ttl = SaOAuth2Manager.getConfig().getAccessTokenTimeout();
            SaManager.getSaTokenDao().set(this.splicingGrantScopeKey(clientId, loginId), scope, ttl);
        }
    }

    public CodeModel getCode(String code) {
        if (code == null) {
            return null;
        }
        return (CodeModel)SaManager.getSaTokenDao().getObject(this.splicingCodeSaveKey(code));
    }

    public String getCodeValue(String clientId, Object loginId) {
        return SaManager.getSaTokenDao().get(this.splicingCodeIndexKey(clientId, loginId));
    }

    public AccessTokenModel getAccessToken(String accessToken) {
        if (accessToken == null) {
            return null;
        }
        return (AccessTokenModel)SaManager.getSaTokenDao().getObject(this.splicingAccessTokenSaveKey(accessToken));
    }

    public String getAccessTokenValue(String clientId, Object loginId) {
        return SaManager.getSaTokenDao().get(this.splicingAccessTokenIndexKey(clientId, loginId));
    }

    public RefreshTokenModel getRefreshToken(String refreshToken) {
        if (refreshToken == null) {
            return null;
        }
        return (RefreshTokenModel)SaManager.getSaTokenDao().getObject(this.splicingRefreshTokenSaveKey(refreshToken));
    }

    public String getRefreshTokenValue(String clientId, Object loginId) {
        return SaManager.getSaTokenDao().get(this.splicingRefreshTokenIndexKey(clientId, loginId));
    }

    public ClientTokenModel getClientToken(String clientToken) {
        if (clientToken == null) {
            return null;
        }
        return (ClientTokenModel)SaManager.getSaTokenDao().getObject(this.splicingClientTokenSaveKey(clientToken));
    }

    public String getClientTokenValue(String clientId) {
        return SaManager.getSaTokenDao().get(this.splicingClientTokenIndexKey(clientId));
    }

    public String getPastTokenValue(String clientId) {
        return SaManager.getSaTokenDao().get(this.splicingPastTokenIndexKey(clientId));
    }

    public String getGrantScope(String clientId, Object loginId) {
        return SaManager.getSaTokenDao().get(this.splicingGrantScopeKey(clientId, loginId));
    }

    public void deleteCode(String code) {
        if (code != null) {
            SaManager.getSaTokenDao().deleteObject(this.splicingCodeSaveKey(code));
        }
    }

    public void deleteCodeIndex(String clientId, Object loginId) {
        SaManager.getSaTokenDao().delete(this.splicingCodeIndexKey(clientId, loginId));
    }

    public void deleteAccessToken(String accessToken) {
        if (accessToken != null) {
            SaManager.getSaTokenDao().deleteObject(this.splicingAccessTokenSaveKey(accessToken));
        }
    }

    public void deleteAccessTokenIndex(String clientId, Object loginId) {
        SaManager.getSaTokenDao().delete(this.splicingAccessTokenIndexKey(clientId, loginId));
    }

    public void deleteRefreshToken(String refreshToken) {
        if (refreshToken != null) {
            SaManager.getSaTokenDao().deleteObject(this.splicingRefreshTokenSaveKey(refreshToken));
        }
    }

    public void deleteRefreshTokenIndex(String clientId, Object loginId) {
        SaManager.getSaTokenDao().delete(this.splicingRefreshTokenIndexKey(clientId, loginId));
    }

    public void deleteClientToken(String clientToken) {
        if (clientToken != null) {
            SaManager.getSaTokenDao().deleteObject(this.splicingClientTokenSaveKey(clientToken));
        }
    }

    public void deleteClientTokenIndex(String clientId) {
        SaManager.getSaTokenDao().delete(this.splicingClientTokenIndexKey(clientId));
    }

    public void deletePastTokenIndex(String clientId) {
        SaManager.getSaTokenDao().delete(this.splicingPastTokenIndexKey(clientId));
    }

    public void deleteGrantScope(String clientId, Object loginId) {
        SaManager.getSaTokenDao().delete(this.splicingGrantScopeKey(clientId, loginId));
    }

    public String randomCode(String clientId, Object loginId, String scope) {
        return SaFoxUtil.getRandomString((int)60);
    }

    public String randomAccessToken(String clientId, Object loginId, String scope) {
        return SaFoxUtil.getRandomString((int)60);
    }

    public String randomRefreshToken(String clientId, Object loginId, String scope) {
        return SaFoxUtil.getRandomString((int)60);
    }

    public String randomClientToken(String clientId, String scope) {
        return SaFoxUtil.getRandomString((int)60);
    }

    public String splicingCodeSaveKey(String code) {
        return SaManager.getConfig().getTokenName() + ":oauth2:code:" + code;
    }

    public String splicingCodeIndexKey(String clientId, Object loginId) {
        return SaManager.getConfig().getTokenName() + ":oauth2:code-index:" + clientId + ":" + loginId;
    }

    public String splicingAccessTokenSaveKey(String accessToken) {
        return SaManager.getConfig().getTokenName() + ":oauth2:access-token:" + accessToken;
    }

    public String splicingAccessTokenIndexKey(String clientId, Object loginId) {
        return SaManager.getConfig().getTokenName() + ":oauth2:access-token-index:" + clientId + ":" + loginId;
    }

    public String splicingRefreshTokenSaveKey(String refreshToken) {
        return SaManager.getConfig().getTokenName() + ":oauth2:refresh-token:" + refreshToken;
    }

    public String splicingRefreshTokenIndexKey(String clientId, Object loginId) {
        return SaManager.getConfig().getTokenName() + ":oauth2:refresh-token-index:" + clientId + ":" + loginId;
    }

    public String splicingClientTokenSaveKey(String clientToken) {
        return SaManager.getConfig().getTokenName() + ":oauth2:client-token:" + clientToken;
    }

    public String splicingClientTokenIndexKey(String clientId) {
        return SaManager.getConfig().getTokenName() + ":oauth2:client-token-indedx:" + clientId;
    }

    public String splicingPastTokenIndexKey(String clientId) {
        return SaManager.getConfig().getTokenName() + ":oauth2:past-token-indedx:" + clientId;
    }

    public String splicingGrantScopeKey(String clientId, Object loginId) {
        return SaManager.getConfig().getTokenName() + ":oauth2:grant-scope:" + clientId + ":" + loginId;
    }
}

