/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.oauth2.logic;

import cn.dev33.satoken.SaTokenManager;
import cn.dev33.satoken.exception.SaTokenException;
import cn.dev33.satoken.oauth2.SaOAuth2Manager;
import cn.dev33.satoken.oauth2.logic.SaOAuth2Util;
import cn.dev33.satoken.oauth2.model.AccessTokenModel;
import cn.dev33.satoken.oauth2.model.CodeModel;
import cn.dev33.satoken.oauth2.model.RequestAuthModel;
import cn.dev33.satoken.oauth2.util.SaOAuth2InsideUtil;
import cn.dev33.satoken.util.SaTokenInsideUtil;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;

public interface SaOAuth2Interface {
    default public List<String> getAppScopeList() {
        return Arrays.asList("userinfo");
    }

    default public List<String> getClientScopeList(String clientId) {
        return this.getAppScopeList();
    }

    default public List<String> getGrantScopeList(Object loginId, String clientId) {
        return Arrays.asList(new String[0]);
    }

    default public String getClientDomain(String clientId) {
        return "*";
    }

    default public String getClientSecret(String clientId) {
        return null;
    }

    default public String getOpenid(String clientId, Object loginId) {
        return null;
    }

    default public Object getLoginId(String clientId, String openid) {
        return null;
    }

    default public void checkContract(String clientId, String scope) {
        List<String> scopelist;
        List<String> clientScopeList = this.getClientScopeList(clientId);
        if (!clientScopeList.containsAll(scopelist = Arrays.asList(scope.split(",")))) {
            throw new SaTokenException("\u8bf7\u6c42\u6388\u6743\u8303\u56f4\u8d85\u51fa\u6216\u65e0\u6548");
        }
    }

    default public boolean isGrant(Object loginId, String clientId, String scope) {
        List<String> grantScopeList = this.getGrantScopeList(loginId, clientId);
        List<String> scopeList = this.convertStringToList(scope);
        return grantScopeList.containsAll(scopeList);
    }

    default public void checkRightUrl(String clientId, String url) {
        if (!SaOAuth2InsideUtil.isUrl(url)) {
            throw new SaTokenException("url\u683c\u5f0f\u9519\u8bef");
        }
        String domain = this.getClientDomain(clientId);
        if (domain == null || "".equals(domain)) {
            throw new SaTokenException("\u91cd\u5b9a\u5411\u5730\u5740\u65e0\u6548");
        }
        if ("*".equals(domain)) {
            return;
        }
        try {
            String host = new URL(url).getHost();
            List<String> domainList = this.convertStringToList(domain);
            if (!domainList.contains(host)) {
                throw new SaTokenException("\u91cd\u5b9a\u5411\u5730\u5740\u4e0d\u5728\u5217\u8868\u4e2d");
            }
        }
        catch (MalformedURLException e) {
            throw new SaTokenException("url\u683c\u5f0f\u9519\u8bef", (Throwable)e);
        }
    }

    default public CodeModel checkCodeIdSecret(String code, String clientId, String clientSecret) {
        CodeModel codeModel = this.getCode(code);
        if (codeModel == null) {
            throw new SaTokenException("\u65e0\u6548code");
        }
        if (!codeModel.getClientId().equals(clientId)) {
            throw new SaTokenException("\u65e0\u6548client_id");
        }
        String dbClientSecret = this.getClientSecret(clientId);
        System.out.println(dbClientSecret);
        System.out.println(clientSecret);
        if (dbClientSecret == null || !dbClientSecret.equals(clientSecret)) {
            throw new SaTokenException("\u65e0\u6548client_secret");
        }
        return codeModel;
    }

    default public AccessTokenModel checkTokenIdSecret(String accessToken, String clientId, String clientSecret) {
        AccessTokenModel tokenModel = this.getAccessToken(accessToken);
        if (tokenModel == null) {
            throw new SaTokenException("\u65e0\u6548access_token");
        }
        if (!tokenModel.getClientId().equals(clientId)) {
            throw new SaTokenException("\u65e0\u6548client_id");
        }
        String dbClientSecret = this.getClientSecret(clientId);
        if (dbClientSecret == null || dbClientSecret.equals(clientSecret)) {
            throw new SaTokenException("\u65e0\u6548client_secret");
        }
        return tokenModel;
    }

    default public CodeModel generateCode(RequestAuthModel authModel) {
        String clientId = authModel.getClientId();
        String scope = authModel.getScope();
        Object loginId = authModel.getLoginId();
        String redirectUri = authModel.getRedirectUri();
        String state = authModel.getState();
        this.checkContract(clientId, scope);
        this.checkRightUrl(clientId, redirectUri);
        String code = this.createCode(clientId, scope, loginId);
        CodeModel codeModel = new CodeModel(code, clientId, scope, loginId);
        String url = this.splicingParame(redirectUri, "code=" + code);
        if (state != null) {
            url = this.splicingParame(url, "state=" + state);
        }
        codeModel.setRedirectUri(url);
        codeModel.setRejectUri(this.splicingParame(redirectUri, "handle=reject"));
        codeModel.setIsConfirm(this.isGrant(loginId, clientId, scope));
        long codeTimeout = SaOAuth2Manager.getConfig().getCodeTimeout();
        SaTokenManager.getSaTokenDao().setObject(this.getKeyCodeModel(code), (Object)codeModel, codeTimeout);
        String key = this.getKeyClientLoginId(loginId, clientId);
        SaTokenManager.getSaTokenDao().delete(key);
        SaTokenManager.getSaTokenDao().set(key, code, codeTimeout);
        return codeModel;
    }

    default public CodeModel getCode(String code) {
        return (CodeModel)SaTokenManager.getSaTokenDao().getObject(this.getKeyCodeModel(code));
    }

    default public void updateCode(String code, CodeModel codeModel) {
        SaTokenManager.getSaTokenDao().updateObject(this.getKeyCodeModel(code), (Object)codeModel);
    }

    default public void confirmCode(String code) {
        CodeModel codeModel = this.getCode(code);
        if (codeModel.getIsConfirm().booleanValue()) {
            return;
        }
        codeModel.setIsConfirm(true);
        this.updateCode(code, codeModel);
    }

    default public void deleteCode(String code) {
        SaTokenManager.getSaTokenDao().deleteObject(this.getKeyCodeModel(code));
    }

    default public AccessTokenModel generateAccessToken(CodeModel codeModel) {
        if (codeModel == null) {
            throw new SaTokenException("\u65e0\u6548code");
        }
        if (!codeModel.getIsConfirm().booleanValue()) {
            throw new SaTokenException("\u8be5code\u5c1a\u672a\u6388\u6743");
        }
        AccessTokenModel tokenModel = this.converCodeToAccessToken(codeModel);
        SaTokenManager.getSaTokenDao().setObject(this.getKeyAccessToken(tokenModel.getAccessToken()), (Object)tokenModel, SaOAuth2Manager.getConfig().getAccessTokenTimeout());
        SaTokenManager.getSaTokenDao().setObject(this.getKeyRefreshToken(tokenModel.getRefreshToken()), (Object)codeModel, SaOAuth2Manager.getConfig().getRefreshTokenTimeout());
        return tokenModel;
    }

    default public AccessTokenModel getAccessToken(String accessToken) {
        return (AccessTokenModel)SaTokenManager.getSaTokenDao().getObject(this.getKeyAccessToken(accessToken));
    }

    default public AccessTokenModel refreshAccessToken(String refreshToken) {
        CodeModel codeModel = this.getRefreshToken(refreshToken);
        if (codeModel == null) {
            throw new SaTokenException("\u65e0\u6548refresh_token");
        }
        AccessTokenModel tokenModel = this.converCodeToAccessToken(codeModel);
        tokenModel.setRefreshToken(refreshToken);
        SaTokenManager.getSaTokenDao().setObject(this.getKeyAccessToken(tokenModel.getAccessToken()), (Object)tokenModel, SaOAuth2Manager.getConfig().getAccessTokenTimeout());
        return tokenModel;
    }

    default public CodeModel getRefreshToken(String refreshToken) {
        return (CodeModel)SaTokenManager.getSaTokenDao().getObject(this.getKeyRefreshToken(refreshToken));
    }

    default public long getAccessTokenExpiresIn(String accessToken) {
        return SaTokenManager.getSaTokenDao().getObjectTimeout(this.getKeyAccessToken(accessToken));
    }

    default public long getRefreshTokenExpiresIn(String refreshToken) {
        return SaTokenManager.getSaTokenDao().getObjectTimeout(this.getKeyRefreshToken(refreshToken));
    }

    default public Object getLoginIdByAccessToken(String accessToken) {
        AccessTokenModel tokenModel = SaOAuth2Util.getAccessToken(accessToken);
        if (tokenModel == null) {
            throw new SaTokenException("\u65e0\u6548access_token");
        }
        return this.getLoginId(tokenModel.getClientId(), tokenModel.getOpenid());
    }

    default public List<String> convertStringToList(String str) {
        return Arrays.asList(str.split(","));
    }

    default public String createCode(String clientId, String scope, Object loginId) {
        return SaTokenInsideUtil.getRandomString((int)60).toLowerCase();
    }

    default public String createAccessToken(CodeModel codeModel) {
        return SaTokenInsideUtil.getRandomString((int)60).toLowerCase();
    }

    default public String createRefreshToken(CodeModel codeModel) {
        return SaTokenInsideUtil.getRandomString((int)60).toLowerCase();
    }

    default public String splicingParame(String url, String parameStr) {
        if (parameStr == null || parameStr.length() == 0) {
            return url;
        }
        int index = url.indexOf(63);
        if (index == -1) {
            return url + '?' + parameStr;
        }
        if (index == url.length() - 1) {
            return url + parameStr;
        }
        if (index > -1 && index < url.length() - 1) {
            String separatorChar = "&";
            if (url.lastIndexOf(separatorChar) != url.length() - 1 && parameStr.indexOf(separatorChar) != 0) {
                return url + separatorChar + parameStr;
            }
            return url + parameStr;
        }
        return url;
    }

    default public AccessTokenModel converCodeToAccessToken(CodeModel codeModel) {
        if (codeModel == null) {
            throw new SaTokenException("\u65e0\u6548code");
        }
        AccessTokenModel tokenModel = new AccessTokenModel();
        tokenModel.setAccessToken(this.createAccessToken(codeModel));
        tokenModel.setRefreshToken(this.createRefreshToken(codeModel));
        tokenModel.setCode(codeModel.getCode());
        tokenModel.setClientId(codeModel.getClientId());
        tokenModel.setScope(codeModel.getScope());
        tokenModel.setOpenid(this.getOpenid(codeModel.getClientId(), codeModel.getLoginId()));
        tokenModel.setTag(codeModel.getTag());
        return tokenModel;
    }

    default public String getKeyCodeModel(String code) {
        return SaTokenManager.getConfig().getTokenName() + ":oauth2:code:" + code;
    }

    default public String getKeyClientLoginId(Object loginId, String clientId) {
        return SaTokenManager.getConfig().getTokenName() + ":oauth2:newest-code:" + clientId + ":" + loginId;
    }

    default public String getKeyRefreshToken(String refreshToken) {
        return SaTokenManager.getConfig().getTokenName() + ":oauth2:refresh-token:" + refreshToken;
    }

    default public String getKeyAccessToken(String accessToken) {
        return SaTokenManager.getConfig().getTokenName() + ":oauth2:access-token:" + accessToken;
    }
}

