/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.jwt;

import cn.dev33.satoken.context.SaHolder;
import cn.dev33.satoken.dao.SaTokenDao;
import cn.dev33.satoken.exception.ApiDisabledException;
import cn.dev33.satoken.jwt.SaJwtUtil;
import cn.dev33.satoken.jwt.exception.SaJwtException;
import cn.dev33.satoken.listener.SaTokenEventCenter;
import cn.dev33.satoken.stp.SaTokenInfo;
import cn.dev33.satoken.stp.StpLogic;
import cn.dev33.satoken.stp.parameter.SaLoginParameter;
import cn.dev33.satoken.util.SaFoxUtil;
import java.util.Map;

public class StpLogicJwtForStateless
extends StpLogic {
    public StpLogicJwtForStateless() {
        super("login");
    }

    public StpLogicJwtForStateless(String loginType) {
        super(loginType);
    }

    public String jwtSecretKey() {
        String keyt = this.getConfigOrGlobal().getJwtSecretKey();
        SaJwtException.throwByNull(keyt, "\u8bf7\u914d\u7f6ejwt\u79d8\u94a5", 30205);
        return keyt;
    }

    public String createTokenValue(Object loginId, String deviceType, long timeout, Map<String, Object> extraData) {
        return SaJwtUtil.createToken(this.loginType, loginId, deviceType, timeout, extraData, this.jwtSecretKey());
    }

    public SaTokenInfo getTokenInfo() {
        SaTokenInfo info = new SaTokenInfo();
        info.tokenName = this.getTokenName();
        info.tokenValue = this.getTokenValue();
        info.isLogin = this.isLogin();
        info.loginId = this.getLoginIdDefaultNull();
        info.loginType = this.getLoginType();
        info.tokenTimeout = this.getTokenTimeout();
        info.sessionTimeout = -2L;
        info.tokenSessionTimeout = -2L;
        info.tokenActiveTimeout = -2L;
        info.loginDeviceType = this.getLoginDeviceType();
        return info;
    }

    public String createLoginSession(Object id, SaLoginParameter loginParameter) {
        this.checkLoginArgs(id, loginParameter);
        String tokenValue = this.createTokenValue(id, loginParameter.getDeviceType(), loginParameter.getTimeout(), loginParameter.getExtraData());
        SaTokenEventCenter.doLogin((String)this.loginType, (Object)id, (String)tokenValue, (SaLoginParameter)loginParameter);
        return tokenValue;
    }

    public String getLoginIdNotHandle(String tokenValue) {
        try {
            Object loginId = SaJwtUtil.getLoginId(tokenValue, this.loginType, this.jwtSecretKey());
            return String.valueOf(loginId);
        }
        catch (SaJwtException e) {
            if (e.getCode() == 30204) {
                return "-3";
            }
            return null;
        }
    }

    public void logout() {
        String tokenValue = this.getTokenValue();
        if (SaFoxUtil.isEmpty((Object)tokenValue)) {
            return;
        }
        SaHolder.getStorage().delete(this.splicingKeyJustCreatedSave());
        if (this.getConfigOrGlobal().getIsReadCookie().booleanValue()) {
            SaHolder.getResponse().deleteCookie(this.getTokenName());
        }
    }

    public Object getExtra(String key) {
        return this.getExtra(this.getTokenValue(), key);
    }

    public Object getExtra(String tokenValue, String key) {
        return SaJwtUtil.getPayloads(tokenValue, this.loginType, this.jwtSecretKey()).get((Object)key);
    }

    public long getTokenTimeout(String tokenValue) {
        return SaJwtUtil.getTimeout(this.getTokenValue(), this.loginType, this.jwtSecretKey());
    }

    public String getLoginDeviceType() {
        String tokenValue = this.getTokenValue();
        if (tokenValue == null) {
            return null;
        }
        if (!this.isLogin()) {
            return null;
        }
        return SaJwtUtil.getPayloadsNotCheck(tokenValue, this.loginType, this.jwtSecretKey()).getStr((Object)"deviceType");
    }

    public SaTokenDao getSaTokenDao() {
        throw new ApiDisabledException();
    }

    public boolean isSupportExtra() {
        return true;
    }
}

