/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.jboot;

import cn.dev33.satoken.dao.SaTokenDao;
import cn.dev33.satoken.jboot.SaJdkSerializer;
import cn.dev33.satoken.jboot.SaRedisCache;
import cn.dev33.satoken.session.SaSession;
import cn.dev33.satoken.util.SaFoxUtil;
import io.jboot.Jboot;
import io.jboot.components.serializer.JbootSerializer;
import io.jboot.exception.JbootIllegalConfigException;
import io.jboot.support.redis.JbootRedisConfig;
import io.jboot.utils.ConfigUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import redis.clients.jedis.Jedis;

public class SaTokenCacheDao
implements SaTokenDao {
    protected SaRedisCache saRedisCache;
    protected JbootSerializer serializer;
    private Map<String, SaRedisCache> saRedisMap = new ConcurrentHashMap<String, SaRedisCache>();

    public SaTokenCacheDao() {
        JbootRedisConfig config = (JbootRedisConfig)Jboot.config(JbootRedisConfig.class);
        this.saRedisCache = new SaRedisCache(config);
        this.serializer = new SaJdkSerializer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SaTokenCacheDao(String cacheName) {
        SaRedisCache saCache = this.saRedisMap.get(cacheName);
        if (saCache == null) {
            SaTokenCacheDao saTokenCacheDao = this;
            synchronized (saTokenCacheDao) {
                saCache = this.saRedisMap.get(cacheName);
                if (saCache == null) {
                    Map configModels = ConfigUtil.getConfigModels(JbootRedisConfig.class);
                    if (!configModels.containsKey(cacheName)) {
                        throw new JbootIllegalConfigException("Please config \"jboot.redis." + cacheName + ".host\" in your jboot.properties.");
                    }
                    JbootRedisConfig jbootRedisConfig = (JbootRedisConfig)configModels.get(cacheName);
                    saCache = new SaRedisCache(jbootRedisConfig);
                    if (saCache != null) {
                        this.saRedisMap.put(cacheName, saCache);
                    }
                }
            }
        }
        this.saRedisCache = saCache;
        this.serializer = new SaJdkSerializer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(String key) {
        Jedis jedis = this.saRedisCache.getJedis();
        try {
            String string = jedis.get(key);
            return string;
        }
        finally {
            this.saRedisCache.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(String key, String value, long timeout) {
        if (timeout == 0L || timeout <= -2L) {
            return;
        }
        Jedis jedis = this.saRedisCache.getJedis();
        try {
            if (timeout == -1L) {
                jedis.set(key, value);
            } else {
                jedis.setex(key, timeout, value);
            }
        }
        finally {
            this.saRedisCache.returnResource(jedis);
        }
    }

    public void update(String key, String value) {
        long expire = this.getTimeout(key);
        if (expire == -2L) {
            return;
        }
        this.set(key, value, expire);
    }

    public void delete(String key) {
        Jedis jedis = this.saRedisCache.getJedis();
        try {
            jedis.del(key);
        }
        finally {
            this.saRedisCache.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTimeout(String key) {
        Jedis jedis = this.saRedisCache.getJedis();
        try {
            long l = jedis.ttl(key);
            return l;
        }
        finally {
            this.saRedisCache.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTimeout(String key, long timeout) {
        if (timeout == -1L) {
            long expire = this.getTimeout(key);
            if (expire != -1L) {
                this.set(key, this.get(key), timeout);
            }
            return;
        }
        Jedis jedis = this.saRedisCache.getJedis();
        try {
            jedis.expire(key, timeout);
        }
        finally {
            this.saRedisCache.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject(String key) {
        Jedis jedis = this.saRedisCache.getJedis();
        try {
            Object object = this.valueFromBytes(jedis.get(this.keyToBytes(key)));
            return object;
        }
        finally {
            this.saRedisCache.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setObject(String key, Object object, long timeout) {
        if (timeout == 0L || timeout <= -2L) {
            return;
        }
        Jedis jedis = this.saRedisCache.getJedis();
        try {
            if (timeout == -1L) {
                jedis.set(this.keyToBytes(key), this.valueToBytes(object));
            } else {
                jedis.setex(this.keyToBytes(key), timeout, this.valueToBytes(object));
            }
        }
        finally {
            this.saRedisCache.returnResource(jedis);
        }
    }

    public void updateObject(String key, Object object) {
        long expire = this.getObjectTimeout(key);
        if (expire == -2L) {
            return;
        }
        this.setObject(key, object, expire);
    }

    public void deleteObject(String key) {
        Jedis jedis = this.saRedisCache.getJedis();
        try {
            jedis.del(this.keyToBytes(key));
        }
        finally {
            this.saRedisCache.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getObjectTimeout(String key) {
        Jedis jedis = this.saRedisCache.getJedis();
        try {
            long l = jedis.ttl(this.keyToBytes(key));
            return l;
        }
        finally {
            this.saRedisCache.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateObjectTimeout(String key, long timeout) {
        if (timeout == -1L) {
            long expire = this.getObjectTimeout(key);
            if (expire != -1L) {
                this.setObject(key, this.getObject(key), timeout);
            }
            return;
        }
        Jedis jedis = this.saRedisCache.getJedis();
        try {
            jedis.expire(this.keyToBytes(key), timeout);
        }
        finally {
            this.saRedisCache.returnResource(jedis);
        }
    }

    public SaSession getSession(String sessionId) {
        return super.getSession(sessionId);
    }

    public void setSession(SaSession session, long timeout) {
        super.setSession(session, timeout);
    }

    public void updateSession(SaSession session) {
        super.updateSession(session);
    }

    public void deleteSession(String sessionId) {
        super.deleteSession(sessionId);
    }

    public long getSessionTimeout(String sessionId) {
        return super.getSessionTimeout(sessionId);
    }

    public void updateSessionTimeout(String sessionId, long timeout) {
        super.updateSessionTimeout(sessionId, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> searchData(String prefix, String keyword, int start, int size, boolean sortType) {
        Jedis jedis = this.saRedisCache.getJedis();
        try {
            Set keys = jedis.keys(prefix + "*" + keyword + "*");
            ArrayList list = new ArrayList(keys);
            List list2 = SaFoxUtil.searchList(list, (int)start, (int)size, (boolean)sortType);
            return list2;
        }
        finally {
            this.saRedisCache.returnResource(jedis);
        }
    }

    protected byte[] keyToBytes(Object key) {
        return key.toString().getBytes();
    }

    protected byte[] valueToBytes(Object value) {
        return this.serializer.serialize(value);
    }

    protected Object valueFromBytes(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        return this.serializer.deserialize(bytes);
    }
}

