/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.jboot;

import com.jfinal.plugin.ehcache.IDataLoader;
import io.jboot.components.cache.JbootCache;
import io.jboot.components.cache.JbootCacheConfig;
import io.jboot.core.spi.JbootSpi;
import io.jboot.exception.JbootIllegalConfigException;
import io.jboot.support.redis.JbootRedisConfig;
import io.jboot.support.redis.RedisScanResult;
import io.jboot.utils.StrUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.ScanResult;
import redis.clients.jedis.exceptions.JedisConnectionException;

@JbootSpi(value="sacache")
public class SaRedisCache
implements JbootCache {
    protected JbootRedisConfig config;
    protected JedisPool jedisPool;
    private ThreadLocal<String> CACHE_NAME_PREFIX_TL = new ThreadLocal();

    public SaRedisCache(JbootRedisConfig config) {
        this.config = config;
        String host = config.getHost();
        Integer port = config.getPort();
        Integer timeout = config.getTimeout();
        String password = config.getPassword();
        Integer database = config.getDatabase();
        String clientName = config.getClientName();
        if (host.contains(":")) {
            port = Integer.valueOf(host.split(":")[1]);
        }
        JedisPoolConfig poolConfig = new JedisPoolConfig();
        if (StrUtil.isNotBlank((Object)config.getTestWhileIdle())) {
            poolConfig.setTestWhileIdle(config.getTestWhileIdle().booleanValue());
        }
        if (StrUtil.isNotBlank((Object)config.getTestOnBorrow())) {
            poolConfig.setTestOnBorrow(config.getTestOnBorrow().booleanValue());
        }
        if (StrUtil.isNotBlank((Object)config.getTestOnCreate())) {
            poolConfig.setTestOnCreate(config.getTestOnCreate().booleanValue());
        }
        if (StrUtil.isNotBlank((Object)config.getTestOnReturn())) {
            poolConfig.setTestOnReturn(config.getTestOnReturn().booleanValue());
        }
        if (StrUtil.isNotBlank((Object)config.getMinEvictableIdleTimeMillis())) {
            poolConfig.setMinEvictableIdleTimeMillis(config.getMinEvictableIdleTimeMillis().longValue());
        }
        if (StrUtil.isNotBlank((Object)config.getTimeBetweenEvictionRunsMillis())) {
            poolConfig.setTimeBetweenEvictionRunsMillis(config.getTimeBetweenEvictionRunsMillis().longValue());
        }
        if (StrUtil.isNotBlank((Object)config.getNumTestsPerEvictionRun())) {
            poolConfig.setNumTestsPerEvictionRun(config.getNumTestsPerEvictionRun().intValue());
        }
        if (StrUtil.isNotBlank((Object)config.getMaxTotal())) {
            poolConfig.setMaxTotal(config.getMaxTotal().intValue());
        }
        if (StrUtil.isNotBlank((Object)config.getMaxIdle())) {
            poolConfig.setMaxIdle(config.getMaxIdle().intValue());
        }
        if (StrUtil.isNotBlank((Object)config.getMinIdle())) {
            poolConfig.setMinIdle(config.getMinIdle().intValue());
        }
        if (StrUtil.isNotBlank((Object)config.getMaxWaitMillis())) {
            poolConfig.setMaxWaitMillis((long)config.getMaxWaitMillis().intValue());
        }
        this.jedisPool = new JedisPool((GenericObjectPoolConfig)poolConfig, host, port.intValue(), timeout.intValue(), timeout.intValue(), password, database.intValue(), clientName);
    }

    public SaRedisCache(JedisPool jedisPool) {
        this.jedisPool = jedisPool;
    }

    public JbootCache setCurrentCacheNamePrefix(String cacheNamePrefix) {
        if (StrUtil.isNotBlank((Object)cacheNamePrefix)) {
            this.CACHE_NAME_PREFIX_TL.set(cacheNamePrefix);
        } else {
            this.CACHE_NAME_PREFIX_TL.remove();
        }
        return this;
    }

    public void removeCurrentCacheNamePrefix() {
        this.CACHE_NAME_PREFIX_TL.remove();
    }

    public JbootCacheConfig getConfig() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T get(String cacheName, Object key) {
        Jedis jedis = this.getJedis();
        try {
            String string = jedis.get(key.toString());
            return (T)string;
        }
        finally {
            this.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(String cacheName, Object key, Object value) {
        Jedis jedis = this.getJedis();
        try {
            jedis.set(key.toString(), value.toString());
        }
        finally {
            this.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(String cacheName, Object key, Object value, int liveSeconds) {
        Jedis jedis = this.getJedis();
        try {
            jedis.setex(key.toString(), Long.parseLong(liveSeconds + ""), value.toString());
        }
        finally {
            this.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String cacheName, Object key) {
        Jedis jedis = this.getJedis();
        try {
            jedis.del(key.toString());
        }
        finally {
            this.returnResource(jedis);
        }
    }

    public void removeAll(String cacheName) {
    }

    public <T> T get(String cacheName, Object key, IDataLoader dataLoader) {
        return null;
    }

    public <T> T get(String cacheName, Object key, IDataLoader dataLoader, int liveSeconds) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getTtl(String cacheName, Object key) {
        Jedis jedis = this.getJedis();
        try {
            Integer n = jedis.ttl(key.toString()).intValue();
            return n;
        }
        finally {
            this.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTtl(String cacheName, Object key, int seconds) {
        Jedis jedis = this.getJedis();
        try {
            jedis.expire(key.toString(), Long.parseLong(seconds + ""));
        }
        finally {
            this.returnResource(jedis);
        }
    }

    public void refresh(String cacheName, Object key) {
    }

    public void refresh(String cacheName) {
    }

    public List getNames() {
        return null;
    }

    public List getKeys(String cacheName) {
        ArrayList<String> keys = new ArrayList<String>();
        String cursor = "0";
        int scanCount = 1000;
        boolean continueState = true;
        do {
            RedisScanResult<String> redisScanResult = this.scan("*", cursor, scanCount);
            List scanKeys = redisScanResult.getResults();
            cursor = redisScanResult.getCursor();
            if (scanKeys != null && scanKeys.size() > 0) {
                for (String key : scanKeys) {
                    keys.add(key.substring(3));
                }
            }
            if (!redisScanResult.isCompleteIteration()) continue;
            continueState = false;
        } while (continueState);
        return keys;
    }

    public Jedis getJedis() {
        try {
            return this.jedisPool.getResource();
        }
        catch (JedisConnectionException e) {
            throw new JbootIllegalConfigException("can not connect to redis host  " + this.config.getHost() + ":" + this.config.getPort() + " , cause : " + e.toString(), (Throwable)e);
        }
    }

    public void returnResource(Jedis jedis) {
        if (jedis != null) {
            jedis.close();
        }
    }

    public RedisScanResult<String> scan(String pattern, String cursor, int scanCount) {
        ScanParams params = new ScanParams();
        params.match(pattern).count(Integer.valueOf(scanCount));
        try (Jedis jedis = this.getJedis();){
            ScanResult scanResult = jedis.scan(cursor, params);
            RedisScanResult redisScanResult = new RedisScanResult(scanResult.getCursor(), scanResult.getResult());
            return redisScanResult;
        }
    }
}

