/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.dao;

import cn.dev33.satoken.dao.SaTokenDao;
import cn.dev33.satoken.session.SaSession;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.serializer.JdkSerializationRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.stereotype.Component;

@Component
public class SaTokenDaoRedis
implements SaTokenDao {
    @Autowired
    public StringRedisTemplate stringRedisTemplate;
    public RedisTemplate<String, SaSession> sessionRedisTemplate;

    @Autowired
    public void setSessionRedisTemplate(RedisConnectionFactory connectionFactory) {
        StringRedisSerializer keySerializer = new StringRedisSerializer();
        JdkSerializationRedisSerializer valueSerializer = new JdkSerializationRedisSerializer();
        RedisTemplate template = new RedisTemplate();
        template.setConnectionFactory(connectionFactory);
        template.setKeySerializer((RedisSerializer)keySerializer);
        template.setHashKeySerializer((RedisSerializer)keySerializer);
        template.setValueSerializer((RedisSerializer)valueSerializer);
        template.setHashValueSerializer((RedisSerializer)valueSerializer);
        template.afterPropertiesSet();
        if (this.sessionRedisTemplate == null) {
            this.sessionRedisTemplate = template;
        }
    }

    public String getValue(String key) {
        return (String)this.stringRedisTemplate.opsForValue().get((Object)key);
    }

    public void setValue(String key, String value, long timeout) {
        if (timeout == SaTokenDao.NEVER_EXPIRE) {
            this.stringRedisTemplate.opsForValue().set((Object)key, (Object)value);
        } else {
            this.stringRedisTemplate.opsForValue().set((Object)key, (Object)value, timeout, TimeUnit.SECONDS);
        }
    }

    public void updateValue(String key, String value) {
        long expire = this.getTimeout(key);
        if (expire == SaTokenDao.NOT_VALUE_EXPIRE) {
            return;
        }
        this.setValue(key, value, expire);
    }

    public void deleteKey(String key) {
        this.stringRedisTemplate.delete((Object)key);
    }

    public long getTimeout(String key) {
        return this.stringRedisTemplate.getExpire((Object)key);
    }

    public void updateTimeout(String key, long timeout) {
        this.stringRedisTemplate.expire((Object)key, timeout, TimeUnit.SECONDS);
    }

    public SaSession getSession(String sessionId) {
        return (SaSession)this.sessionRedisTemplate.opsForValue().get((Object)sessionId);
    }

    public void saveSession(SaSession session, long timeout) {
        if (timeout == SaTokenDao.NEVER_EXPIRE) {
            this.sessionRedisTemplate.opsForValue().set((Object)session.getId(), (Object)session);
        } else {
            this.sessionRedisTemplate.opsForValue().set((Object)session.getId(), (Object)session, timeout, TimeUnit.SECONDS);
        }
    }

    public void updateSession(SaSession session) {
        long expire = this.getSessionTimeout(session.getId());
        if (expire == SaTokenDao.NOT_VALUE_EXPIRE) {
            return;
        }
        this.saveSession(session, expire);
    }

    public void deleteSession(String sessionId) {
        this.sessionRedisTemplate.delete((Object)sessionId);
    }

    public long getSessionTimeout(String sessionId) {
        return this.sessionRedisTemplate.getExpire((Object)sessionId);
    }

    public void updateSessionTimeout(String sessionId, long timeout) {
        this.sessionRedisTemplate.expire((Object)sessionId, timeout, TimeUnit.SECONDS);
    }
}

