/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.stp;

import cn.dev33.satoken.SaTokenManager;
import cn.dev33.satoken.config.SaTokenConfig;
import cn.dev33.satoken.dao.SaTokenDao;
import cn.dev33.satoken.exception.NotLoginException;
import cn.dev33.satoken.exception.NotPermissionException;
import cn.dev33.satoken.session.SaSession;
import cn.dev33.satoken.stp.SaTokenInfo;
import java.util.List;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

public class StpLogic {
    public String loginKey = "";

    public StpLogic(String loginKey) {
        this.loginKey = loginKey;
    }

    public String getTokenName() {
        return this.getKeyTokenName();
    }

    public String randomTokenValue(Object loginId) {
        return SaTokenManager.getSaTokenAction().createToken(loginId, this.loginKey);
    }

    public String getTokenValue() {
        Cookie cookie;
        HttpServletRequest request = SaTokenManager.getSaTokenServlet().getRequest();
        SaTokenConfig config = SaTokenManager.getConfig();
        String keyTokenName = this.getTokenName();
        String tokenValue = null;
        if (request.getAttribute("JUST_CREATED_SAVE_KEY_") != null) {
            tokenValue = String.valueOf(request.getAttribute("JUST_CREATED_SAVE_KEY_"));
        }
        if (tokenValue == null && config.getIsReadBody().booleanValue()) {
            tokenValue = request.getParameter(keyTokenName);
        }
        if (tokenValue == null && config.getIsReadHead().booleanValue()) {
            tokenValue = request.getHeader(keyTokenName);
        }
        if (tokenValue == null && config.getIsReadCookie().booleanValue() && (cookie = SaTokenManager.getSaTokenCookie().getCookie(request, keyTokenName)) != null) {
            tokenValue = cookie.getValue();
        }
        return tokenValue;
    }

    public String getTokenValueByLoginId(Object loginId) {
        return SaTokenManager.getSaTokenDao().getValue(this.getKeyLoginId(loginId));
    }

    public String getLoginKey() {
        return this.loginKey;
    }

    public SaTokenInfo getTokenInfo() {
        SaTokenInfo info = new SaTokenInfo();
        info.tokenName = this.getTokenName();
        info.tokenValue = this.getTokenValue();
        info.isLogin = this.isLogin();
        info.loginId = this.getLoginIdDefaultNull();
        info.loginKey = this.getLoginKey();
        info.tokenTimeout = this.getTokenTimeout();
        info.sessionTimeout = this.getSessionTimeout();
        info.tokenActivityTimeout = this.getTokenActivityTimeout();
        return info;
    }

    public void setLoginId(Object loginId) {
        HttpServletRequest request = SaTokenManager.getSaTokenServlet().getRequest();
        SaTokenConfig config = SaTokenManager.getConfig();
        SaTokenDao dao = SaTokenManager.getSaTokenDao();
        String tokenValue = this.getTokenValueByLoginId(loginId);
        if (tokenValue == null) {
            tokenValue = this.randomTokenValue(loginId);
        } else if (!config.getIsShare().booleanValue()) {
            dao.updateValue(this.getKeyTokenValue(tokenValue), "-4");
            this.clearLastActivity(tokenValue);
            tokenValue = this.randomTokenValue(loginId);
        }
        dao.setValue(this.getKeyTokenValue(tokenValue), String.valueOf(loginId), config.getTimeout());
        dao.setValue(this.getKeyLoginId(loginId), tokenValue, config.getTimeout());
        request.setAttribute("JUST_CREATED_SAVE_KEY_", (Object)tokenValue);
        this.setLastActivityToNow(tokenValue);
        if (config.getIsReadCookie().booleanValue()) {
            SaTokenManager.getSaTokenCookie().addCookie(SaTokenManager.getSaTokenServlet().getResponse(), this.getTokenName(), tokenValue, "/", (int)config.getTimeout());
        }
    }

    public void logout() {
        String loginId;
        String tokenValue = this.getTokenValue();
        if (tokenValue == null) {
            return;
        }
        if (SaTokenManager.getConfig().getIsReadCookie().booleanValue()) {
            SaTokenManager.getSaTokenCookie().delCookie(SaTokenManager.getSaTokenServlet().getRequest(), SaTokenManager.getSaTokenServlet().getResponse(), this.getTokenName());
        }
        if ((loginId = SaTokenManager.getSaTokenDao().getValue(this.getKeyTokenValue(tokenValue))) == null) {
            return;
        }
        if (loginId.equals("-3") || loginId.equals("-4") || loginId.equals("-5")) {
            return;
        }
        this.logoutByLoginId(loginId);
    }

    public void logoutByLoginId(Object loginId) {
        String tokenValue = this.getTokenValueByLoginId(loginId);
        if (tokenValue == null) {
            return;
        }
        SaTokenManager.getSaTokenDao().deleteKey(this.getKeyTokenValue(tokenValue));
        SaTokenManager.getSaTokenDao().deleteKey(this.getKeyLoginId(loginId));
        SaTokenManager.getSaTokenDao().deleteSession(this.getKeySession(loginId));
        this.clearLastActivity(tokenValue);
    }

    public void kickoutByLoginId(Object loginId) {
        String tokenValue = this.getTokenValueByLoginId(loginId);
        if (tokenValue == null) {
            return;
        }
        SaTokenManager.getSaTokenDao().updateValue(this.getKeyTokenValue(tokenValue), "-5");
        SaTokenManager.getSaTokenDao().deleteKey(this.getKeyLoginId(loginId));
        SaTokenManager.getSaTokenDao().deleteSession(this.getKeySession(loginId));
        this.clearLastActivity(tokenValue);
    }

    public boolean isLogin() {
        return this.getLoginIdDefaultNull() != null;
    }

    public void checkLogin() {
        this.getLoginId();
    }

    public Object getLoginId() {
        String tokenValue = this.getTokenValue();
        if (tokenValue == null) {
            throw NotLoginException.newInstance(this.loginKey, "-1");
        }
        String loginId = SaTokenManager.getSaTokenDao().getValue(this.getKeyTokenValue(tokenValue));
        if (loginId == null) {
            throw NotLoginException.newInstance(this.loginKey, "-2");
        }
        if (loginId.equals("-3")) {
            throw NotLoginException.newInstance(this.loginKey, "-3");
        }
        if (loginId.equals("-4")) {
            throw NotLoginException.newInstance(this.loginKey, "-4");
        }
        if (loginId.equals("-5")) {
            throw NotLoginException.newInstance(this.loginKey, "-5");
        }
        this.checkActivityTimeout(tokenValue);
        this.updateLastActivityToNow(tokenValue);
        return loginId;
    }

    public <T> T getLoginId(T defaultValue) {
        Object loginId = this.getLoginIdDefaultNull();
        if (loginId == null) {
            return defaultValue;
        }
        if (defaultValue instanceof Integer) {
            return (T)Integer.valueOf(loginId.toString());
        }
        if (defaultValue instanceof Long) {
            return (T)Long.valueOf(loginId.toString());
        }
        if (defaultValue instanceof String) {
            return (T)loginId.toString();
        }
        return (T)loginId;
    }

    public Object getLoginIdDefaultNull() {
        String tokenValue = this.getTokenValue();
        if (tokenValue == null) {
            return null;
        }
        String loginId = SaTokenManager.getSaTokenDao().getValue(this.getKeyTokenValue(tokenValue));
        if (loginId == null || NotLoginException.ABNORMAL_LIST.contains(loginId)) {
            return null;
        }
        if (this.getTokenActivityTimeoutByToken(tokenValue) == SaTokenDao.NOT_VALUE_EXPIRE.longValue()) {
            return null;
        }
        return loginId;
    }

    public String getLoginIdAsString() {
        return String.valueOf(this.getLoginId());
    }

    public int getLoginIdAsInt() {
        return Integer.valueOf(String.valueOf(this.getLoginId()));
    }

    public long getLoginIdAsLong() {
        return Long.valueOf(String.valueOf(this.getLoginId()));
    }

    public Object getLoginIdByToken(String tokenValue) {
        String loginId;
        if (tokenValue != null && (loginId = SaTokenManager.getSaTokenDao().getValue(this.getKeyTokenValue(tokenValue))) != null) {
            return loginId;
        }
        return null;
    }

    protected SaSession getSessionBySessionId(String sessionId, boolean isCreate) {
        SaSession session = SaTokenManager.getSaTokenDao().getSession(sessionId);
        if (session == null && isCreate) {
            session = new SaSession(sessionId);
            SaTokenManager.getSaTokenDao().saveSession(session, SaTokenManager.getConfig().getTimeout());
        }
        return session;
    }

    public SaSession getSessionByLoginId(Object loginId, boolean isCreate) {
        return this.getSessionBySessionId(this.getKeySession(loginId), isCreate);
    }

    public SaSession getSessionByLoginId(Object loginId) {
        return this.getSessionByLoginId(loginId, true);
    }

    public SaSession getSession(boolean isCreate) {
        return this.getSessionByLoginId(this.getLoginId(), isCreate);
    }

    public SaSession getSession() {
        return this.getSession(true);
    }

    protected void setLastActivityToNow(String tokenValue) {
        if (tokenValue == null || SaTokenManager.getConfig().getActivityTimeout() == SaTokenDao.NEVER_EXPIRE.longValue()) {
            return;
        }
        SaTokenManager.getSaTokenDao().setValue(this.getKeyLastActivityTime(tokenValue), String.valueOf(System.currentTimeMillis()), SaTokenManager.getConfig().getTimeout());
    }

    protected void clearLastActivity(String tokenValue) {
        if (tokenValue == null || SaTokenManager.getConfig().getActivityTimeout() == SaTokenDao.NEVER_EXPIRE.longValue()) {
            return;
        }
        SaTokenManager.getSaTokenDao().deleteKey(this.getKeyLastActivityTime(tokenValue));
        SaTokenManager.getSaTokenServlet().getRequest().removeAttribute("TOKEN_ACTIVITY_TIMEOUT_CHECKED_KEY_");
    }

    public void checkActivityTimeout(String tokenValue) {
        if (tokenValue == null || SaTokenManager.getConfig().getActivityTimeout() == SaTokenDao.NEVER_EXPIRE.longValue()) {
            return;
        }
        HttpServletRequest request = SaTokenManager.getSaTokenServlet().getRequest();
        if (request.getAttribute("TOKEN_ACTIVITY_TIMEOUT_CHECKED_KEY_") != null) {
            return;
        }
        long timeout = this.getTokenActivityTimeoutByToken(tokenValue);
        if (timeout == SaTokenDao.NEVER_EXPIRE) {
            return;
        }
        if (timeout == SaTokenDao.NOT_VALUE_EXPIRE) {
            throw NotLoginException.newInstance(this.loginKey, "-3");
        }
        request.setAttribute("TOKEN_ACTIVITY_TIMEOUT_CHECKED_KEY_", (Object)true);
    }

    public void checkActivityTimeout() {
        this.checkActivityTimeout(this.getTokenValue());
    }

    public void updateLastActivityToNow(String tokenValue) {
        if (tokenValue == null || SaTokenManager.getConfig().getActivityTimeout() == SaTokenDao.NEVER_EXPIRE.longValue()) {
            return;
        }
        SaTokenManager.getSaTokenDao().updateValue(this.getKeyLastActivityTime(tokenValue), String.valueOf(System.currentTimeMillis()));
    }

    public void updateLastActivityToNow() {
        this.updateLastActivityToNow(this.getTokenValue());
    }

    public long getTokenTimeout() {
        return SaTokenManager.getSaTokenDao().getTimeout(this.getKeyTokenValue(this.getTokenValue()));
    }

    public long getTokenTimeoutByLoginId(Object loginId) {
        return SaTokenManager.getSaTokenDao().getTimeout(this.getKeyTokenValue(this.getTokenValueByLoginId(loginId)));
    }

    public long getSessionTimeout() {
        return this.getSessionTimeoutByLoginId(this.getLoginIdDefaultNull());
    }

    public long getSessionTimeoutByLoginId(Object loginId) {
        return SaTokenManager.getSaTokenDao().getSessionTimeout(this.getKeySession(loginId));
    }

    public long getTokenActivityTimeout() {
        return this.getTokenActivityTimeoutByToken(this.getTokenValue());
    }

    public long getTokenActivityTimeoutByToken(String tokenValue) {
        if (tokenValue == null) {
            return SaTokenDao.NOT_VALUE_EXPIRE;
        }
        if (SaTokenManager.getConfig().getActivityTimeout() == SaTokenDao.NEVER_EXPIRE.longValue()) {
            return SaTokenDao.NEVER_EXPIRE;
        }
        String keyLastActivityTime = this.getKeyLastActivityTime(tokenValue);
        String lastActivityTimeString = SaTokenManager.getSaTokenDao().getValue(keyLastActivityTime);
        if (lastActivityTimeString == null) {
            return SaTokenDao.NOT_VALUE_EXPIRE;
        }
        long lastActivityTime = Long.valueOf(lastActivityTimeString);
        long apartSecond = (System.currentTimeMillis() - lastActivityTime) / 1000L;
        long timeout = SaTokenManager.getConfig().getActivityTimeout() - apartSecond;
        if (timeout < 0L) {
            return SaTokenDao.NOT_VALUE_EXPIRE;
        }
        return timeout;
    }

    public boolean hasPermission(Object loginId, Object pcode) {
        List<Object> pcodeList = SaTokenManager.getStpInterface().getPermissionCodeList(loginId, this.loginKey);
        return pcodeList != null && pcodeList.contains(pcode);
    }

    public boolean hasPermission(Object pcode) {
        return this.hasPermission(this.getLoginId(), pcode);
    }

    public void checkPermission(Object pcode) {
        if (!this.hasPermission(pcode)) {
            throw new NotPermissionException(pcode, this.loginKey);
        }
    }

    public void checkPermissionAnd(Object ... pcodeArray) {
        Object loginId = this.getLoginId();
        List<Object> pcodeList = SaTokenManager.getStpInterface().getPermissionCodeList(loginId, this.loginKey);
        for (Object pcode : pcodeArray) {
            if (pcodeList.contains(pcode)) continue;
            throw new NotPermissionException(pcode, this.loginKey);
        }
    }

    public void checkPermissionOr(Object ... pcodeArray) {
        Object loginId = this.getLoginId();
        List<Object> pcodeList = SaTokenManager.getStpInterface().getPermissionCodeList(loginId, this.loginKey);
        for (Object pcode : pcodeArray) {
            if (!pcodeList.contains(pcode)) continue;
            return;
        }
        if (pcodeArray.length > 0) {
            throw new NotPermissionException(pcodeArray[0], this.loginKey);
        }
    }

    public String getKeyTokenName() {
        return SaTokenManager.getConfig().getTokenName();
    }

    public String getKeyTokenValue(String tokenValue) {
        return SaTokenManager.getConfig().getTokenName() + ":" + this.loginKey + ":token:" + tokenValue;
    }

    public String getKeyLoginId(Object loginId) {
        return SaTokenManager.getConfig().getTokenName() + ":" + this.loginKey + ":id:" + loginId;
    }

    public String getKeySession(Object loginId) {
        return SaTokenManager.getConfig().getTokenName() + ":" + this.loginKey + ":session:" + loginId;
    }

    public String getKeyLastActivityTime(String tokenValue) {
        return SaTokenManager.getConfig().getTokenName() + ":" + this.loginKey + ":last-activity:" + tokenValue;
    }
}

