/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.session;

import cn.dev33.satoken.SaTokenManager;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class SaSession
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String id;
    private long createTime;
    private Map<String, Object> dataMap;

    public SaSession(String id) {
        this.id = id;
        this.createTime = System.currentTimeMillis();
        this.dataMap = new HashMap<String, Object>();
    }

    public String getId() {
        return this.id;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public void setAttribute(String key, Object value) {
        this.dataMap.put(key, value);
        this.update();
    }

    public Object getAttribute(String key) {
        return this.dataMap.get(key);
    }

    public Object getAttribute(String key, Object defaultValue) {
        Object value = this.getAttribute(key);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    public void removeAttribute(String key) {
        this.dataMap.remove(key);
        this.update();
    }

    public void clearAttribute() {
        this.dataMap.clear();
        this.update();
    }

    public boolean containsAttribute(String key) {
        return this.dataMap.keySet().contains(key);
    }

    public Set<String> getAttributeKeys() {
        return this.dataMap.keySet();
    }

    public Map<String, Object> getDataMap() {
        return this.dataMap;
    }

    public void update() {
        SaTokenManager.getSaTokenDao().updateSession(this);
    }
}

