/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.dao;

import cn.dev33.satoken.dao.SaTokenDao;
import cn.dev33.satoken.session.SaSession;
import java.util.HashMap;
import java.util.Map;

public class SaTokenDaoDefaultImpl
implements SaTokenDao {
    public Map<String, Object> dataMap = new HashMap<String, Object>();
    public Map<String, Long> expireMap = new HashMap<String, Long>();

    @Override
    public String getValue(String key) {
        this.clearKeyByTimeout(key);
        return (String)this.dataMap.get(key);
    }

    @Override
    public void setValue(String key, String value, long timeout) {
        this.dataMap.put(key, value);
        this.expireMap.put(key, timeout == SaTokenDao.NEVER_EXPIRE ? SaTokenDao.NEVER_EXPIRE : System.currentTimeMillis() + timeout * 1000L);
    }

    @Override
    public void updateValue(String key, String value) {
        if (this.getKeyTimeout(key) == SaTokenDao.NOT_VALUE_EXPIRE.longValue()) {
            return;
        }
        this.dataMap.put(key, value);
    }

    @Override
    public void deleteKey(String key) {
        this.dataMap.remove(key);
        this.expireMap.remove(key);
    }

    @Override
    public long getTimeout(String key) {
        return this.getKeyTimeout(key);
    }

    @Override
    public SaSession getSession(String sessionId) {
        this.clearKeyByTimeout(sessionId);
        return (SaSession)this.dataMap.get(sessionId);
    }

    @Override
    public void saveSession(SaSession session, long timeout) {
        this.dataMap.put(session.getId(), session);
        this.expireMap.put(session.getId(), timeout == SaTokenDao.NEVER_EXPIRE ? SaTokenDao.NEVER_EXPIRE : System.currentTimeMillis() + timeout * 1000L);
    }

    @Override
    public void updateSession(SaSession session) {
        if (this.getKeyTimeout(session.getId()) == SaTokenDao.NOT_VALUE_EXPIRE.longValue()) {
            return;
        }
    }

    @Override
    public void deleteSession(String sessionId) {
        this.dataMap.remove(sessionId);
        this.expireMap.remove(sessionId);
    }

    @Override
    public long getSessionTimeout(String sessionId) {
        return this.getKeyTimeout(sessionId);
    }

    void clearKeyByTimeout(String key) {
        Long expirationTime = this.expireMap.get(key);
        if (expirationTime != null && expirationTime != SaTokenDao.NEVER_EXPIRE && expirationTime < System.currentTimeMillis()) {
            this.dataMap.remove(key);
            this.expireMap.remove(key);
        }
    }

    long getKeyTimeout(String key) {
        this.clearKeyByTimeout(key);
        Long expire = this.expireMap.get(key);
        if (expire == null) {
            return SaTokenDao.NOT_VALUE_EXPIRE;
        }
        if (expire == SaTokenDao.NEVER_EXPIRE) {
            return SaTokenDao.NEVER_EXPIRE;
        }
        long timeout = (expire - System.currentTimeMillis()) / 1000L;
        if (timeout < 0L) {
            this.dataMap.remove(key);
            this.expireMap.remove(key);
            return SaTokenDao.NOT_VALUE_EXPIRE;
        }
        return timeout;
    }
}

