/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.strategy;

import cn.dev33.satoken.SaManager;
import cn.dev33.satoken.exception.SaTokenException;
import cn.dev33.satoken.fun.strategy.SaAutoRenewFunction;
import cn.dev33.satoken.fun.strategy.SaCreateSessionFunction;
import cn.dev33.satoken.fun.strategy.SaCreateStpLogicFunction;
import cn.dev33.satoken.fun.strategy.SaCreateTokenFunction;
import cn.dev33.satoken.fun.strategy.SaGenerateUniqueTokenFunction;
import cn.dev33.satoken.fun.strategy.SaHasElementFunction;
import cn.dev33.satoken.session.SaSession;
import cn.dev33.satoken.stp.StpLogic;
import cn.dev33.satoken.util.SaFoxUtil;
import java.util.UUID;

public final class SaStrategy {
    public static final SaStrategy instance;
    public SaCreateTokenFunction createToken = (loginId, loginType) -> {
        String tokenStyle;
        switch (tokenStyle = SaManager.getStpLogic(loginType).getConfigOrGlobal().getTokenStyle()) {
            case "uuid": {
                return UUID.randomUUID().toString();
            }
            case "simple-uuid": {
                return UUID.randomUUID().toString().replaceAll("-", "");
            }
            case "random-32": {
                return SaFoxUtil.getRandomString(32);
            }
            case "random-64": {
                return SaFoxUtil.getRandomString(64);
            }
            case "random-128": {
                return SaFoxUtil.getRandomString(128);
            }
            case "tik": {
                return SaFoxUtil.getRandomString(2) + "_" + SaFoxUtil.getRandomString(14) + "_" + SaFoxUtil.getRandomString(16) + "__";
            }
        }
        SaManager.getLog().warn("\u914d\u7f6e\u7684 tokenStyle \u503c\u65e0\u6548\uff1a{}\uff0c\u4ec5\u5141\u8bb8\u4ee5\u4e0b\u53d6\u503c: uuid\u3001simple-uuid\u3001random-32\u3001random-64\u3001random-128\u3001tik", tokenStyle);
        return UUID.randomUUID().toString();
    };
    public SaCreateSessionFunction createSession = sessionId -> new SaSession((String)sessionId);
    public volatile Class<? extends SaSession> sessionClassType = SaSession.class;
    public SaHasElementFunction hasElement = (list, element) -> {
        if (list == null || list.size() == 0) {
            return false;
        }
        if (list.contains(element)) {
            return true;
        }
        for (String patt : list) {
            if (!SaFoxUtil.vagueMatch(patt, element)) continue;
            return true;
        }
        return false;
    };
    public SaGenerateUniqueTokenFunction generateUniqueToken = (elementName, maxTryTimes, createTokenFunction, checkTokenFunction) -> {
        int i = 1;
        while (true) {
            String token = (String)createTokenFunction.get();
            if (maxTryTimes == -1) {
                return token;
            }
            if (((Boolean)checkTokenFunction.apply(token)).booleanValue()) {
                return token;
            }
            if (i >= maxTryTimes) {
                throw new SaTokenException(elementName + " \u751f\u6210\u5931\u8d25\uff0c\u5df2\u5c1d\u8bd5" + i + "\u6b21\uff0c\u751f\u6210\u7b97\u6cd5\u8fc7\u4e8e\u7b80\u5355\u6216\u8d44\u6e90\u6c60\u5df2\u8017\u5c3d");
            }
            ++i;
        }
    };
    public SaAutoRenewFunction autoRenew = stpLogic -> stpLogic.getConfigOrGlobal().getAutoRenew();
    public SaCreateStpLogicFunction createStpLogic = loginType -> new StpLogic((String)loginType);
    @Deprecated
    public static final SaStrategy me;

    private SaStrategy() {
    }

    public SaStrategy setCreateToken(SaCreateTokenFunction createToken) {
        this.createToken = createToken;
        return this;
    }

    public SaStrategy setCreateSession(SaCreateSessionFunction createSession) {
        this.createSession = createSession;
        return this;
    }

    public SaStrategy setHasElement(SaHasElementFunction hasElement) {
        this.hasElement = hasElement;
        return this;
    }

    public SaStrategy setGenerateUniqueToken(SaGenerateUniqueTokenFunction generateUniqueToken) {
        this.generateUniqueToken = generateUniqueToken;
        return this;
    }

    public SaStrategy setCreateStpLogic(SaCreateStpLogicFunction createStpLogic) {
        this.createStpLogic = createStpLogic;
        return this;
    }

    public SaStrategy setAutoRenew(SaAutoRenewFunction autoRenew) {
        this.autoRenew = autoRenew;
        return this;
    }

    static {
        me = instance = new SaStrategy();
    }
}

