/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.session;

import cn.dev33.satoken.SaManager;
import cn.dev33.satoken.application.SaSetValueInterface;
import cn.dev33.satoken.fun.SaTwoParamFunction;
import cn.dev33.satoken.listener.SaTokenEventCenter;
import cn.dev33.satoken.session.SaTerminalInfo;
import cn.dev33.satoken.util.SaFoxUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;

public class SaSession
implements SaSetValueInterface,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String USER = "USER";
    public static final String ROLE_LIST = "ROLE_LIST";
    public static final String PERMISSION_LIST = "PERMISSION_LIST";
    private String id;
    private String type;
    private String loginType;
    private Object loginId;
    private String token;
    private int historyTerminalCount;
    private long createTime;
    private Map<String, Object> dataMap = new ConcurrentHashMap<String, Object>();
    private List<SaTerminalInfo> terminalList = new Vector<SaTerminalInfo>();

    public SaSession() {
    }

    public SaSession(String id) {
        this.id = id;
        this.createTime = System.currentTimeMillis();
        SaTokenEventCenter.doCreateSession(id);
    }

    public String getId() {
        return this.id;
    }

    public SaSession setId(String id) {
        this.id = id;
        return this;
    }

    public String getType() {
        return this.type;
    }

    public SaSession setType(String type) {
        this.type = type;
        return this;
    }

    public String getLoginType() {
        return this.loginType;
    }

    public SaSession setLoginType(String loginType) {
        this.loginType = loginType;
        return this;
    }

    public Object getLoginId() {
        return this.loginId;
    }

    public SaSession setLoginId(Object loginId) {
        this.loginId = loginId;
        return this;
    }

    public String getToken() {
        return this.token;
    }

    public SaSession setToken(String token) {
        this.token = token;
        return this;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public SaSession setCreateTime(long createTime) {
        this.createTime = createTime;
        return this;
    }

    public void setTerminalList(List<SaTerminalInfo> terminalList) {
        this.terminalList = terminalList;
    }

    public List<SaTerminalInfo> getTerminalList() {
        return this.terminalList;
    }

    public List<SaTerminalInfo> terminalListCopy() {
        return new ArrayList<SaTerminalInfo>(this.terminalList);
    }

    public List<SaTerminalInfo> getTerminalListByDeviceType(String deviceType) {
        if (deviceType == null) {
            return this.terminalListCopy();
        }
        List<SaTerminalInfo> copyList = this.terminalListCopy();
        ArrayList<SaTerminalInfo> newList = new ArrayList<SaTerminalInfo>();
        for (SaTerminalInfo terminal : copyList) {
            if (!SaFoxUtil.equals(terminal.getDeviceType(), deviceType)) continue;
            newList.add(terminal);
        }
        return newList;
    }

    public List<String> getTokenValueListByDeviceType(String deviceType) {
        ArrayList<String> tokenValueList = new ArrayList<String>();
        for (SaTerminalInfo terminal : this.getTerminalListByDeviceType(deviceType)) {
            tokenValueList.add(terminal.getTokenValue());
        }
        return tokenValueList;
    }

    public SaTerminalInfo getTerminal(String tokenValue) {
        for (SaTerminalInfo terminal : this.terminalListCopy()) {
            if (!SaFoxUtil.equals(terminal.getTokenValue(), tokenValue)) continue;
            return terminal;
        }
        return null;
    }

    public void addTerminal(SaTerminalInfo terminalInfo) {
        SaTerminalInfo oldTerminal = this.getTerminal(terminalInfo.getTokenValue());
        if (oldTerminal != null) {
            this.terminalList.remove(oldTerminal);
        }
        ++this.historyTerminalCount;
        terminalInfo.setIndex(this.historyTerminalCount);
        this.terminalList.add(terminalInfo);
        this.update();
    }

    public void removeTerminal(String tokenValue) {
        SaTerminalInfo terminalInfo = this.getTerminal(tokenValue);
        if (this.terminalList.remove(terminalInfo)) {
            this.update();
        }
    }

    public int getHistoryTerminalCount() {
        return this.historyTerminalCount;
    }

    public void setHistoryTerminalCount(int historyTerminalCount) {
        this.historyTerminalCount = historyTerminalCount;
    }

    public void forEachTerminalList(SaTwoParamFunction<SaSession, SaTerminalInfo> function) {
        for (SaTerminalInfo terminalInfo : this.terminalListCopy()) {
            function.run(this, terminalInfo);
        }
    }

    public boolean isTrustDeviceId(String deviceId) {
        if (SaFoxUtil.isEmpty(deviceId)) {
            return false;
        }
        for (SaTerminalInfo terminal : this.terminalListCopy()) {
            if (!SaFoxUtil.equals(terminal.getDeviceId(), deviceId)) continue;
            return true;
        }
        return false;
    }

    public void update() {
        SaManager.getSaTokenDao().updateSession(this);
    }

    public void logout() {
        SaManager.getSaTokenDao().deleteSession(this.id);
        SaTokenEventCenter.doLogoutSession(this.id);
    }

    public void logoutByTerminalCountToZero() {
        if (this.terminalList.isEmpty()) {
            this.logout();
        }
    }

    public long timeout() {
        return SaManager.getSaTokenDao().getSessionTimeout(this.id);
    }

    public void updateTimeout(long timeout) {
        SaManager.getSaTokenDao().updateSessionTimeout(this.id, timeout);
    }

    public void updateMinTimeout(long minTimeout) {
        long min = this.trans(minTimeout);
        long curr = this.trans(this.timeout());
        if (curr < min) {
            this.updateTimeout(minTimeout);
        }
    }

    public void updateMaxTimeout(long maxTimeout) {
        long max = this.trans(maxTimeout);
        long curr = this.trans(this.timeout());
        if (curr > max) {
            this.updateTimeout(maxTimeout);
        }
    }

    protected long trans(long value) {
        return value == -1L ? Long.MAX_VALUE : value;
    }

    @Override
    public Object get(String key) {
        return this.dataMap.get(key);
    }

    @Override
    public SaSession set(String key, Object value) {
        this.dataMap.put(key, value);
        this.update();
        return this;
    }

    @Override
    public SaSession setByNull(String key, Object value) {
        if (!this.has(key)) {
            this.dataMap.put(key, value);
            this.update();
        }
        return this;
    }

    @Override
    public SaSession delete(String key) {
        this.dataMap.remove(key);
        this.update();
        return this;
    }

    public Set<String> keys() {
        return this.dataMap.keySet();
    }

    public void clear() {
        this.dataMap.clear();
        this.update();
    }

    public Map<String, Object> getDataMap() {
        return this.dataMap;
    }

    public SaSession setDataMap(Map<String, Object> dataMap) {
        this.dataMap = dataMap;
        return this;
    }

    public SaSession refreshDataMap(Map<String, Object> dataMap) {
        this.dataMap.clear();
        this.dataMap.putAll(dataMap);
        this.update();
        return this;
    }
}

