/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.util;

import cn.dev33.satoken.exception.SaTokenException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Random;
import java.util.regex.Pattern;

public class SaFoxUtil {
    public static final String URL_REGEX = "(https?|ftp|file)://[-A-Za-z0-9+&@#/%?=~_|!:,.;]+[-A-Za-z0-9+&@#/%=~_|]";

    public static void printSaToken() {
        String str = "____ ____    ___ ____ _  _ ____ _  _ \r\n[__  |__| __  |  |  | |_/  |___ |\\ | \r\n___] |  |     |  |__| | \\_ |___ | \\| \r\nDevDoc\uff1ahttp://sa-token.dev33.cn (v1.29.0)\r\nGitHub\uff1ahttps://github.com/dromara/sa-token";
        System.out.println(str);
    }

    public static String getRandomString(int length) {
        String str = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
        Random random = new Random();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            int number = random.nextInt(62);
            sb.append(str.charAt(number));
        }
        return sb.toString();
    }

    public static boolean isEmpty(Object str) {
        return str == null || "".equals(str);
    }

    public static boolean isNotEmpty(Object str) {
        return !SaFoxUtil.isEmpty(str);
    }

    public static String getMarking28() {
        return System.currentTimeMillis() + "" + new Random().nextInt(Integer.MAX_VALUE);
    }

    public static String formatDate(Date date) {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(date);
    }

    public static List<String> searchList(Collection<String> dataList, String prefix, String keyword, int start, int size) {
        if (prefix == null) {
            prefix = "";
        }
        if (keyword == null) {
            keyword = "";
        }
        ArrayList<String> list = new ArrayList<String>();
        for (String key : dataList) {
            if (!key.startsWith(prefix) || key.indexOf(keyword) <= -1) continue;
            list.add(key);
        }
        return SaFoxUtil.searchList(list, start, size);
    }

    public static List<String> searchList(List<String> list, int start, int size) {
        if (start < 0) {
            return list;
        }
        int end = start + size;
        ArrayList<String> list2 = new ArrayList<String>();
        for (int i = start; i < end; ++i) {
            if (i >= list.size()) {
                return list2;
            }
            list2.add(list.get(i));
        }
        return list2;
    }

    public static boolean vagueMatch(String patt, String str) {
        if (patt.indexOf("*") == -1) {
            return patt.equals(str);
        }
        return Pattern.matches(patt.replaceAll("\\*", ".*"), str);
    }

    public static <T> T getValueByType(Object obj, Class<T> cs) {
        if (obj == null || obj.getClass().equals(cs)) {
            return (T)obj;
        }
        String obj2 = String.valueOf(obj);
        Object obj3 = null;
        obj3 = cs.equals(String.class) ? obj2 : (cs.equals(Integer.TYPE) || cs.equals(Integer.class) ? Integer.valueOf(obj2) : (cs.equals(Long.TYPE) || cs.equals(Long.class) ? Long.valueOf(obj2) : (cs.equals(Short.TYPE) || cs.equals(Short.class) ? Short.valueOf(obj2) : (cs.equals(Byte.TYPE) || cs.equals(Byte.class) ? Byte.valueOf(obj2) : (cs.equals(Float.TYPE) || cs.equals(Float.class) ? Float.valueOf(obj2) : (cs.equals(Double.TYPE) || cs.equals(Double.class) ? Double.valueOf(obj2) : (cs.equals(Boolean.TYPE) || cs.equals(Boolean.class) ? Boolean.valueOf(obj2) : obj)))))));
        return (T)obj3;
    }

    public static String joinParam(String url, String parameStr) {
        int index;
        if (parameStr == null || parameStr.length() == 0) {
            return url;
        }
        if (url == null) {
            url = "";
        }
        if ((index = url.lastIndexOf(63)) == -1) {
            return url + '?' + parameStr;
        }
        if (index == url.length() - 1) {
            return url + parameStr;
        }
        if (index > -1 && index < url.length() - 1) {
            String separatorChar = "&";
            if (url.lastIndexOf(separatorChar) != url.length() - 1 && parameStr.indexOf(separatorChar) != 0) {
                return url + separatorChar + parameStr;
            }
            return url + parameStr;
        }
        return url;
    }

    public static String joinParam(String url, String key, Object value) {
        if (SaFoxUtil.isEmpty(url) || SaFoxUtil.isEmpty(key) || SaFoxUtil.isEmpty(value)) {
            return url;
        }
        return SaFoxUtil.joinParam(url, key + "=" + value);
    }

    public static String joinSharpParam(String url, String parameStr) {
        int index;
        if (parameStr == null || parameStr.length() == 0) {
            return url;
        }
        if (url == null) {
            url = "";
        }
        if ((index = url.lastIndexOf(35)) == -1) {
            return url + '#' + parameStr;
        }
        if (index == url.length() - 1) {
            return url + parameStr;
        }
        if (index > -1 && index < url.length() - 1) {
            String separatorChar = "&";
            if (url.lastIndexOf(separatorChar) != url.length() - 1 && parameStr.indexOf(separatorChar) != 0) {
                return url + separatorChar + parameStr;
            }
            return url + parameStr;
        }
        return url;
    }

    public static String joinSharpParam(String url, String key, Object value) {
        if (SaFoxUtil.isEmpty(url) || SaFoxUtil.isEmpty(key) || SaFoxUtil.isEmpty(value)) {
            return url;
        }
        return SaFoxUtil.joinSharpParam(url, key + "=" + value);
    }

    public static String arrayJoin(String[] arr) {
        if (arr == null) {
            return "";
        }
        String str = "";
        for (int i = 0; i < arr.length; ++i) {
            str = str + arr[i];
            if (i == arr.length - 1) continue;
            str = str + ",";
        }
        return str;
    }

    public static boolean isUrl(String str) {
        if (str == null) {
            return false;
        }
        return str.toLowerCase().matches(URL_REGEX);
    }

    public static String encodeUrl(String url) {
        try {
            return URLEncoder.encode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new SaTokenException(e);
        }
    }

    public static String decoderUrl(String url) {
        try {
            return URLDecoder.decode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new SaTokenException(e);
        }
    }

    public static List<String> convertStringToList(String str) {
        String[] arr;
        ArrayList<String> list = new ArrayList<String>();
        if (SaFoxUtil.isEmpty(str)) {
            return list;
        }
        for (String s : arr = str.split(",")) {
            if (SaFoxUtil.isEmpty(s = s.trim())) continue;
            list.add(s);
        }
        return list;
    }

    public static String convertListToString(List<?> list) {
        if (list == null || list.size() == 0) {
            return "";
        }
        String str = "";
        for (int i = 0; i < list.size(); ++i) {
            str = str + list.get(i);
            if (i == list.size() - 1) continue;
            str = str + ",";
        }
        return str;
    }

    public static String[] convertStringToArray(String str) {
        List<String> list = SaFoxUtil.convertStringToList(str);
        return list.toArray(new String[list.size()]);
    }

    public static String convertArrayToString(String[] arr) {
        if (arr == null || arr.length == 0) {
            return "";
        }
        return String.join((CharSequence)",", arr);
    }

    public static <T> List<T> emptyList() {
        return new ArrayList();
    }

    public static List<String> toList(String ... strs) {
        ArrayList<String> list = new ArrayList<String>();
        for (String str : strs) {
            list.add(str);
        }
        return list;
    }
}

