/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.session;

import cn.dev33.satoken.SaTokenManager;
import cn.dev33.satoken.session.TokenSign;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;

public class SaSession
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String id;
    private long createTime;
    private final Map<String, Object> dataMap = new ConcurrentHashMap<String, Object>();
    private final List<TokenSign> tokenSignList = new Vector<TokenSign>();

    public SaSession() {
    }

    public SaSession(String id) {
        this.id = id;
        this.createTime = System.currentTimeMillis();
    }

    public String getId() {
        return this.id;
    }

    public SaSession setId(String id) {
        this.id = id;
        return this;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public SaSession setCreateTime(long createTime) {
        this.createTime = createTime;
        return this;
    }

    public List<TokenSign> getTokenSignList() {
        return new Vector<TokenSign>(this.tokenSignList);
    }

    public TokenSign getTokenSign(String tokenValue) {
        for (TokenSign tokenSign : this.getTokenSignList()) {
            if (!tokenSign.getValue().equals(tokenValue)) continue;
            return tokenSign;
        }
        return null;
    }

    public void addTokenSign(TokenSign tokenSign) {
        for (TokenSign tokenSign2 : this.getTokenSignList()) {
            if (!tokenSign2.getValue().equals(tokenSign.getValue())) continue;
            return;
        }
        this.tokenSignList.add(tokenSign);
        this.update();
    }

    public void removeTokenSign(String tokenValue) {
        TokenSign tokenSign = this.getTokenSign(tokenValue);
        if (this.tokenSignList.remove(tokenSign)) {
            this.update();
        }
    }

    public void setAttribute(String key, Object value) {
        this.dataMap.put(key, value);
        this.update();
    }

    public Object getAttribute(String key) {
        return this.dataMap.get(key);
    }

    public Object getAttribute(String key, Object defaultValue) {
        Object value = this.getAttribute(key);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    public void removeAttribute(String key) {
        this.dataMap.remove(key);
        this.update();
    }

    public void clearAttribute() {
        this.dataMap.clear();
        this.update();
    }

    public boolean containsAttribute(String key) {
        return this.dataMap.containsKey(key);
    }

    public Set<String> attributeKeys() {
        return this.dataMap.keySet();
    }

    public Map<String, Object> getDataMap() {
        return this.dataMap;
    }

    public void refreshDataMap(Map<String, Object> dataMap) {
        this.dataMap.clear();
        this.dataMap.putAll(dataMap);
        this.update();
    }

    public void update() {
        SaTokenManager.getSaTokenDao().updateSession(this);
    }

    public void logout() {
        SaTokenManager.getSaTokenDao().deleteSession(this.id);
    }

    public void logoutByTokenSignCountToZero() {
        if (this.tokenSignList.size() == 0) {
            this.logout();
        }
    }

    public long getTimeout() {
        return SaTokenManager.getSaTokenDao().getSessionTimeout(this.id);
    }

    public void updateTimeout(long timeout) {
        SaTokenManager.getSaTokenDao().updateSessionTimeout(this.id, timeout);
    }

    public void updateMinTimeout(long minTimeout) {
        if (this.getTimeout() < minTimeout) {
            SaTokenManager.getSaTokenDao().updateSessionTimeout(this.id, minTimeout);
        }
    }

    public void updateMaxTimeout(long maxTimeout) {
        if (this.getTimeout() > maxTimeout) {
            SaTokenManager.getSaTokenDao().updateSessionTimeout(this.id, maxTimeout);
        }
    }

    public void set(String key, Object value) {
        this.dataMap.put(key, value);
        this.update();
    }

    public void setDefaultValue(String key, Object value) {
        if (!this.has(key)) {
            this.dataMap.put(key, value);
            this.update();
        }
    }

    public Object get(String key) {
        return this.dataMap.get(key);
    }

    public <T> T get(String key, T defaultValue) {
        return this.getValueByDefaultValue(this.get(key), defaultValue);
    }

    public String getString(String key) {
        Object value = this.get(key);
        if (value == null) {
            return null;
        }
        return String.valueOf(value);
    }

    public int getInt(String key) {
        return this.getValueByDefaultValue(this.get(key), 0);
    }

    public long getLong(String key) {
        return this.getValueByDefaultValue(this.get(key), 0L);
    }

    public double getDouble(String key) {
        return this.getValueByDefaultValue(this.get(key), 0.0);
    }

    public float getFloat(String key) {
        return this.getValueByDefaultValue(this.get(key), Float.valueOf(0.0f)).floatValue();
    }

    public <T> T getModel(String key, Class<T> cs) {
        return this.getValueByClass(this.get(key), cs);
    }

    public <T> T getModel(String key, Class<T> cs, Object defaultValue) {
        Object value = this.get(key);
        if (this.valueIsNull(value)) {
            return (T)defaultValue;
        }
        return this.getValueByClass(value, cs);
    }

    public boolean has(String key) {
        return !this.valueIsNull(this.get(key));
    }

    public void delete(String key) {
        this.dataMap.remove(key);
        this.update();
    }

    public boolean valueIsNull(Object value) {
        return value == null || value.equals("");
    }

    protected <T> T getValueByClass(Object obj, Class<T> cs) {
        if (obj != null && obj.getClass().equals(cs)) {
            return (T)obj;
        }
        String obj2 = String.valueOf(obj);
        Object obj3 = null;
        obj3 = cs.equals(String.class) ? obj2 : (cs.equals(Integer.TYPE) || cs.equals(Integer.class) ? Integer.valueOf(obj2) : (cs.equals(Long.TYPE) || cs.equals(Long.class) ? Long.valueOf(obj2) : (cs.equals(Short.TYPE) || cs.equals(Short.class) ? Short.valueOf(obj2) : (cs.equals(Byte.TYPE) || cs.equals(Byte.class) ? Byte.valueOf(obj2) : (cs.equals(Float.TYPE) || cs.equals(Float.class) ? Float.valueOf(obj2) : (cs.equals(Double.TYPE) || cs.equals(Double.class) ? Double.valueOf(obj2) : (cs.equals(Boolean.TYPE) || cs.equals(Boolean.class) ? Boolean.valueOf(obj2) : obj)))))));
        return (T)obj3;
    }

    protected <T> T getValueByDefaultValue(Object value, T defaultValue) {
        if (this.valueIsNull(value)) {
            return defaultValue;
        }
        Class<?> cs = defaultValue.getClass();
        return (T)this.getValueByClass(value, cs);
    }
}

