/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.dao;

import cn.dev33.satoken.SaTokenManager;
import cn.dev33.satoken.dao.SaTokenDao;
import cn.dev33.satoken.session.SaSession;
import cn.dev33.satoken.util.SaTaskUtil;
import cn.dev33.satoken.util.SaTokenInsideUtil;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.concurrent.ConcurrentHashMap;

public class SaTokenDaoDefaultImpl
implements SaTokenDao {
    public Map<String, Object> dataMap = new ConcurrentHashMap<String, Object>();
    public Map<String, Long> expireMap = new ConcurrentHashMap<String, Long>();
    public Timer refreshTimer;

    public SaTokenDaoDefaultImpl() {
        this.initRefreshTimer();
    }

    @Override
    public String getValue(String key) {
        this.clearKeyByTimeout(key);
        return (String)this.dataMap.get(key);
    }

    @Override
    public void setValue(String key, String value, long timeout) {
        this.dataMap.put(key, value);
        this.expireMap.put(key, timeout == SaTokenDao.NEVER_EXPIRE ? SaTokenDao.NEVER_EXPIRE : System.currentTimeMillis() + timeout * 1000L);
    }

    @Override
    public void updateValue(String key, String value) {
        if (this.getKeyTimeout(key) == SaTokenDao.NOT_VALUE_EXPIRE.longValue()) {
            return;
        }
        this.dataMap.put(key, value);
    }

    @Override
    public void deleteKey(String key) {
        this.dataMap.remove(key);
        this.expireMap.remove(key);
    }

    @Override
    public long getTimeout(String key) {
        return this.getKeyTimeout(key);
    }

    @Override
    public void updateTimeout(String key, long timeout) {
        this.expireMap.put(key, System.currentTimeMillis() + timeout * 1000L);
    }

    @Override
    public SaSession getSession(String sessionId) {
        this.clearKeyByTimeout(sessionId);
        return (SaSession)this.dataMap.get(sessionId);
    }

    @Override
    public void saveSession(SaSession session, long timeout) {
        this.dataMap.put(session.getId(), session);
        this.expireMap.put(session.getId(), timeout == SaTokenDao.NEVER_EXPIRE ? SaTokenDao.NEVER_EXPIRE : System.currentTimeMillis() + timeout * 1000L);
    }

    @Override
    public void updateSession(SaSession session) {
        if (this.getKeyTimeout(session.getId()) == SaTokenDao.NOT_VALUE_EXPIRE.longValue()) {
            return;
        }
    }

    @Override
    public void deleteSession(String sessionId) {
        this.dataMap.remove(sessionId);
        this.expireMap.remove(sessionId);
    }

    @Override
    public long getSessionTimeout(String sessionId) {
        return this.getKeyTimeout(sessionId);
    }

    @Override
    public void updateSessionTimeout(String sessionId, long timeout) {
        this.expireMap.put(sessionId, System.currentTimeMillis() + timeout * 1000L);
    }

    void clearKeyByTimeout(String key) {
        Long expirationTime = this.expireMap.get(key);
        if (expirationTime != null && expirationTime != SaTokenDao.NEVER_EXPIRE && expirationTime < System.currentTimeMillis()) {
            this.dataMap.remove(key);
            this.expireMap.remove(key);
        }
    }

    long getKeyTimeout(String key) {
        this.clearKeyByTimeout(key);
        Long expire = this.expireMap.get(key);
        if (expire == null) {
            return SaTokenDao.NOT_VALUE_EXPIRE;
        }
        if (expire == SaTokenDao.NEVER_EXPIRE) {
            return SaTokenDao.NEVER_EXPIRE;
        }
        long timeout = (expire - System.currentTimeMillis()) / 1000L;
        if (timeout < 0L) {
            this.dataMap.remove(key);
            this.expireMap.remove(key);
            return SaTokenDao.NOT_VALUE_EXPIRE;
        }
        return timeout;
    }

    public void refreshDataMap() {
        Iterator<String> keys = this.expireMap.keySet().iterator();
        while (keys.hasNext()) {
            this.clearKeyByTimeout(keys.next());
        }
    }

    public void initRefreshTimer() {
        if (this.refreshTimer != null) {
            this.endRefreshTimer();
        }
        if (SaTokenManager.getConfig().getDataRefreshPeriod() < 0) {
            return;
        }
        int period = SaTokenManager.getConfig().getDataRefreshPeriod() * 1000;
        this.refreshTimer = SaTaskUtil.setInterval(new SaTaskUtil.FunctionRunClass(){

            @Override
            public void run() {
                SaTokenDaoDefaultImpl.this.refreshDataMap();
            }
        }, period, period);
    }

    public void endRefreshTimer() {
        this.refreshTimer.cancel();
    }

    @Override
    public List<String> searchData(String prefix, String keyword, int start, int size) {
        return SaTokenInsideUtil.searchList(this.expireMap.keySet(), prefix, keyword, start, size);
    }
}

