/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.context.grpc.interceptor;

import cn.dev33.satoken.SaManager;
import cn.dev33.satoken.context.SaTokenContextDefaultImpl;
import cn.dev33.satoken.context.grpc.constants.GrpcContextConstants;
import cn.dev33.satoken.id.SaIdUtil;
import cn.dev33.satoken.stp.StpUtil;
import cn.dev33.satoken.util.SaFoxUtil;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.ForwardingClientCallListener;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import net.devh.boot.grpc.client.interceptor.GrpcGlobalClientInterceptor;
import org.springframework.core.Ordered;

@GrpcGlobalClientInterceptor
public class SaTokenGrpcClientInterceptor
implements ClientInterceptor,
Ordered {
    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(next.newCall(method, callOptions)){

            public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                String tokenValue;
                if (SaManager.getConfig().getCheckIdToken().booleanValue()) {
                    headers.put(GrpcContextConstants.SA_ID_TOKEN, (Object)SaIdUtil.getToken());
                }
                if (SaFoxUtil.isNotEmpty((Object)(tokenValue = StpUtil.getTokenValue())) && SaManager.getSaTokenContextOrSecond() != SaTokenContextDefaultImpl.defaultContext) {
                    headers.put(GrpcContextConstants.SA_JUST_CREATED_NOT_PREFIX, (Object)tokenValue);
                }
                super.start((ClientCall.Listener)new ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT>(responseListener){

                    public void onClose(Status status, Metadata responseHeader) {
                        StpUtil.setTokenValue((String)((String)responseHeader.get(GrpcContextConstants.SA_JUST_CREATED_NOT_PREFIX)));
                        super.onClose(status, responseHeader);
                    }
                }, headers);
            }
        };
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }
}

