/*
 * Decompiled with CFR 0.152.
 */
package cn.detachment.frame.web.filter;

import cn.detachment.frame.core.util.SystemClock;
import cn.detachment.frame.web.util.NetworkUtil;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.annotation.Order;
import org.springframework.web.filter.OncePerRequestFilter;

@Order(value=-2147483648)
@WebFilter(filterName="webServerTraceFilter", urlPatterns={"/*"}, asyncSupported=true)
public class WebServerTraceFilter
extends OncePerRequestFilter {
    private static Logger logger = LoggerFactory.getLogger(WebServerTraceFilter.class);
    public static final String TRACE_ID = "TRACE_ID";
    @Value(value="${detachment.web.trace.enabled:true}")
    private boolean requestTraceEnabled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws ServletException, IOException {
        try {
            long start = SystemClock.INSTANCE.currentTimeMillis();
            MDC.put((String)TRACE_ID, (String)Long.toString(start));
            long end = SystemClock.INSTANCE.currentTimeMillis();
            this.logTrace(httpServletRequest, httpServletResponse, end - start);
        }
        finally {
            MDC.remove((String)TRACE_ID);
        }
    }

    private void logTrace(HttpServletRequest request, HttpServletResponse response, long time) {
        if (this.requestTraceEnabled) {
            logger.info("{} {} {} {} {} {}", new Object[]{NetworkUtil.getIpAddress(request), request.getMethod(), request.getRequestURI(), request.getProtocol(), response.getStatus(), time});
        }
    }
}

