/*
 * Decompiled with CFR 0.152.
 */
package cn.detachment.frame.notification.config;

import cn.detachment.frame.notification.support.MailUtil;
import cn.detachment.frame.notification.support.impl.MailUtilImpl;
import java.util.Properties;
import javax.mail.Session;
import javax.mail.Transport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@ConfigurationProperties(prefix="detachment.mail")
@Configuration
public class MailConfiguration {
    private static Logger logger = LoggerFactory.getLogger(MailConfiguration.class);
    private String account;
    private String password;
    private String host;
    private String port;
    private boolean debug;

    @Bean
    public Session mailSession() {
        Properties properties = new Properties();
        properties.setProperty("mail.smtp.host", this.host);
        properties.setProperty("mail.smtp.port", this.port);
        properties.setProperty("mail.smtp.auth", "true");
        properties.setProperty("mail.debug", String.valueOf(this.debug));
        properties.setProperty("mail.transport", "smtp");
        properties.setProperty("mail.smtp.ssl.enable", "true");
        Session session = Session.getInstance((Properties)properties);
        session.setDebug(this.debug);
        return session;
    }

    @Bean(destroyMethod="close")
    @ConditionalOnBean(value={Session.class})
    public Transport mailTransport(Session session) {
        try {
            Transport transport = session.getTransport();
            transport.connect(this.account, this.password);
            return transport;
        }
        catch (Exception e) {
            logger.error("create mail transport error! " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Bean
    @ConditionalOnBean(value={Transport.class, Session.class})
    public MailUtil mailUtil(Transport mailTransport, Session mailSession) {
        return new MailUtilImpl(mailTransport, mailSession);
    }

    public String getAccount() {
        return this.account;
    }

    public String getPassword() {
        return this.password;
    }

    public String getHost() {
        return this.host;
    }

    public String getPort() {
        return this.port;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }
}

