/*
 * Decompiled with CFR 0.152.
 */
package cn.detachment.core.example.download;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;

public class DownTask {
    String url;
    String fileName;
    String saveParent = "/tmp";
    private String suffix = "";
    String savePath;
    static final long kb = 1024L;
    static final long mb = 0x100000L;
    static final long gb = 0x40000000L;

    public DownTask(String url, String fileName, String savePath) {
        this.url = url;
        this.fileName = fileName;
        this.saveParent = savePath;
        this.suffix = url.substring(url.lastIndexOf("."));
    }

    public DownTask(URL url) {
    }

    public static void main(String[] args) {
        String uri = "https://mirrors.tuna.tsinghua.edu.cn/apache/maven/maven-3/3.6.2/binaries/apache-maven-3.6.2-bin.tar.gz";
        String fn = uri.substring(uri.lastIndexOf("/"));
        try {
            String fp = "D:/tmp" + fn;
            File file = new File(fp);
            if (!file.exists()) {
                file.createNewFile();
            }
            URL url = new URL(uri);
            URLConnection connection = url.openConnection();
            Long fSize = connection.getContentLengthLong();
            try (InputStream in = connection.getInputStream();
                 FileOutputStream fileOutputStream = new FileOutputStream(fp);){
                byte[] buf = new byte[1024];
                while (in.read(buf) != -1) {
                    fileOutputStream.write(buf);
                }
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getUrl() {
        return this.url;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getSaveParent() {
        return this.saveParent;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public String getSavePath() {
        return this.savePath;
    }
}

