/*
 * Decompiled with CFR 0.152.
 */
package retrofit2.converter.fastjson;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.support.config.FastJsonConfig;
import java.io.IOException;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import retrofit2.Converter;

public class FastjsonRequestBodyConverter<T>
implements Converter<T, RequestBody> {
    private FastJsonConfig config;
    private static final MediaType MEDIA_TYPE = MediaType.parse((String)"application/json; charset=UTF-8");

    public FastjsonRequestBodyConverter(FastJsonConfig config) {
        this.config = config;
    }

    public RequestBody convert(T value) throws IOException {
        SerializeConfig serializeConfig = this.config.getSerializeConfig();
        SerializerFeature[] serializerFeatures = this.config.getSerializerFeatures();
        byte[] content = serializeConfig != null ? (serializerFeatures != null ? JSON.toJSONBytes(value, (SerializeConfig)serializeConfig, (SerializerFeature[])serializerFeatures) : JSON.toJSONBytes(value, (SerializeConfig)serializeConfig, (SerializerFeature[])new SerializerFeature[0])) : (serializerFeatures != null ? JSON.toJSONBytes(value, (SerializerFeature[])serializerFeatures) : JSON.toJSONBytes(value, (SerializerFeature[])new SerializerFeature[0]));
        return RequestBody.create((MediaType)MEDIA_TYPE, (byte[])content);
    }
}

