package cn.datastacks.durian;

/**
 * 常量工具类
 *
 * @author yurun
 */
public class Constant {
    /**
     * 连字符
     */
    public static final String AMPERSAND = "&";

    /**
     * =
     */
    public static final String EQUAL = "=";

    /**
     * |
     */
    public static final String VERTICAL_BAR = "|";

    /**
     * ;
     */
    public static final String SEMICOLON = ";";

    /**
     * 空格
     */
    public static final String SPACE = " ";

    /**
     * ,
     */
    public static final String COMMA = ",";

    /**
     * .
     */
    public static final String FULL_STOP = ".";

    /**
     * _
     */
    public static final String UNDERLINE = "_";

    /**
     * /
     */
    public static final String SLASH = "/";

    /**
     * :
     */
    public static final String COLON = ":";
    /**
     * ::
     */
    public static final String DOUBLE_COLON = "::";

    /**
     * \n
     */
    public static final String NEWLINE = "\n";

    /**
     * *
     */
    public static final String ASTERISK = "*";

    /**
     * 空白
     */
    public static final String EMPTY = "";

    /**
     * -
     */
    public static final String DASH = "-";

    /**
     * (
     */
    public static final String LEFT_PARENTHESIS = "(";
    /**
     * )
     */
    public static final String RIGHT_PARENTHESIS = ")";

    /**
     * [
     */
    public static final String LEFT_BRACKET = "[";
    /**
     * ]
     */
    public static final String RIGHT_BRACKET = "]";

    /**
     * {
     */
    public static final String LEFT_BRACE = "{";
    /**
     * }
     */
    public static final String RIGHT_BRACE = "}";

    /**
     * -
     */
    public static final String LINE_THROUGH = "-";

    /**
     * 1
     */
    public static final int POSITIVE_ONE = 1;
    /**
     * -1
     */
    public static final int NEGATIVE_ONE = -1;
    /**
     * 0
     */
    public static final int ZERO = 0;

    /**
     * 空整数数组
     */
    public static final int[] INT_EMPTY_ARRAY = new int[0];
    /**
     * 空长整数数组
     */
    public static final long[] LONG_EMPTY_ARRAY = new long[0];
    /**
     * 空单精度浮点数数组
     */
    public static final float[] FLOAT_EMPTY_ARRAY = new float[0];
    /**
     * 空双精度浮点数数组
     */
    public static final double[] DOUBLE_EMPTY_ARRAY = new double[0];
    /**
     * 空布尔数组
     */
    public static final boolean[] BOOLEAN_EMPTY_ARRAY = new boolean[0];
    /**
     * 空字符串数组
     */
    public static final String[] STRING_EMPTY_ARRAY = new String[0];

    /**
     * 年-月-日
     */
    public static final String LOCAL_DATE = "yyyy-MM-dd";
    /**
     * 年-月-日 时:分:秒
     */
    public static final String LOCAL_DATE_TIME = "yyyy-MM-dd HH:mm:ss";

    /**
     * http
     */
    public static final String HTTP = "http";
    /**
     * https
     */
    public static final String HTTPS = "https";

    /**
     * MD5
     */
    public static final String MD5 = "MD5";

    private Constant() {

    }
}
