/*
 * Decompiled with CFR 0.152.
 */
package ai.dat.reranker.onnx;

import ai.dat.core.configuration.ConfigOption;
import ai.dat.core.configuration.ConfigOptions;
import ai.dat.core.configuration.ReadableConfig;
import ai.dat.core.factories.Factory;
import ai.dat.core.factories.ScoringModelFactory;
import ai.dat.core.utils.FactoryUtil;
import dev.langchain4j.model.scoring.ScoringModel;
import dev.langchain4j.model.scoring.onnx.OnnxScoringModel;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class OnnxScoringModelFactory
implements ScoringModelFactory {
    public static final String IDENTIFIER = "onnx";
    public static final ConfigOption<String> MODEL_FILE_PATH = ConfigOptions.key((String)"model-file-path").stringType().noDefaultValue().withDescription("ONNX model file path, for example: /home/dat/model.onnx\n\nLocal scoring (reranking) models, powered by [ONNX runtime](https://onnxruntime.ai/docs/get-started/with-java.html), running in the same Java process.\nMany models (e.g., from [Hugging Face](https://huggingface.co)) can be used, as long as they are in the ONNX format.\nInformation on how to convert models into ONNX format can be found [here](https://huggingface.co/docs/optimum-onnx/onnx/usage_guides/export_a_model).\nMany models already converted to ONNX format are available [here](https://huggingface.co/Xenova).\n");
    public static final ConfigOption<String> TOKENIZER_FILE_PATH = ConfigOptions.key((String)"tokenizer-file-path").stringType().noDefaultValue().withDescription("Tokenizer file path, for example: /home/dat/tokenizer.json");

    public String factoryIdentifier() {
        return IDENTIFIER;
    }

    public Set<ConfigOption<?>> requiredOptions() {
        return new LinkedHashSet(List.of(MODEL_FILE_PATH, TOKENIZER_FILE_PATH));
    }

    public Set<ConfigOption<?>> optionalOptions() {
        return Collections.emptySet();
    }

    public ScoringModel create(ReadableConfig config) {
        FactoryUtil.validateFactoryOptions((Factory)this, (ReadableConfig)config);
        String modelFilePath = (String)config.get(MODEL_FILE_PATH);
        String tokenizerFilePath = (String)config.get(TOKENIZER_FILE_PATH);
        return new OnnxScoringModel(modelFilePath, tokenizerFilePath);
    }
}

