/*
 * Decompiled with CFR 0.152.
 */
package ai.dat.reranker.jina;

import ai.dat.core.configuration.ConfigOption;
import ai.dat.core.configuration.ConfigOptions;
import ai.dat.core.configuration.ReadableConfig;
import ai.dat.core.factories.Factory;
import ai.dat.core.factories.ScoringModelFactory;
import ai.dat.core.utils.FactoryUtil;
import com.google.common.base.Preconditions;
import dev.langchain4j.model.jina.JinaScoringModel;
import dev.langchain4j.model.scoring.ScoringModel;
import java.time.Duration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class JinaScoringModelFactory
implements ScoringModelFactory {
    public static final String IDENTIFIER = "jina";
    public static final ConfigOption<String> BASE_URL = ConfigOptions.key((String)"base-url").stringType().defaultValue((Object)"https://api.jina.ai/v1/").withDescription("The base URL of Jina server.");
    public static final ConfigOption<String> API_KEY = ConfigOptions.key((String)"api-key").stringType().noDefaultValue().withDescription("The API KEY of Jina server.");
    public static final ConfigOption<String> MODEL_NAME = ConfigOptions.key((String)"model-name").stringType().noDefaultValue().withDescription("The name of the reranking model to use from Jina server.");
    public static final ConfigOption<Duration> TIMEOUT = ConfigOptions.key((String)"timeout").durationType().noDefaultValue().withDescription("The maximum time allowed for the API call to complete.");
    public static final ConfigOption<Integer> MAX_RETRIES = ConfigOptions.key((String)"max-retries").intType().defaultValue((Object)2).withDescription("The maximum number of retries in case of API call failure.");
    public static final ConfigOption<Boolean> LOG_REQUESTS = ConfigOptions.key((String)"log-requests").booleanType().defaultValue((Object)false).withDescription("Whether to print the embedding model requests log");
    public static final ConfigOption<Boolean> LOG_RESPONSES = ConfigOptions.key((String)"log-responses").booleanType().defaultValue((Object)false).withDescription("Whether to print the embedding model responses log");

    public String factoryIdentifier() {
        return IDENTIFIER;
    }

    public Set<ConfigOption<?>> requiredOptions() {
        return new LinkedHashSet(List.of(BASE_URL, API_KEY, MODEL_NAME));
    }

    public Set<ConfigOption<?>> optionalOptions() {
        return new LinkedHashSet(List.of(TIMEOUT, MAX_RETRIES, LOG_REQUESTS, LOG_RESPONSES));
    }

    public ScoringModel create(ReadableConfig config) {
        FactoryUtil.validateFactoryOptions((Factory)this, (ReadableConfig)config);
        this.validateConfigOptions(config);
        String baseUrl = (String)config.get(BASE_URL);
        String apiKey = (String)config.get(API_KEY);
        String modelName = (String)config.get(MODEL_NAME);
        JinaScoringModel.JinaScoringModelBuilder builder = JinaScoringModel.builder().baseUrl(baseUrl).apiKey(apiKey).modelName(modelName);
        config.getOptional(TIMEOUT).ifPresent(arg_0 -> ((JinaScoringModel.JinaScoringModelBuilder)builder).timeout(arg_0));
        config.getOptional(MAX_RETRIES).ifPresent(arg_0 -> ((JinaScoringModel.JinaScoringModelBuilder)builder).maxRetries(arg_0));
        config.getOptional(LOG_REQUESTS).ifPresent(arg_0 -> ((JinaScoringModel.JinaScoringModelBuilder)builder).logRequests(arg_0));
        config.getOptional(LOG_RESPONSES).ifPresent(arg_0 -> ((JinaScoringModel.JinaScoringModelBuilder)builder).logResponses(arg_0));
        return builder.build();
    }

    private void validateConfigOptions(ReadableConfig config) {
        Integer maxRetries = (Integer)config.get(MAX_RETRIES);
        Preconditions.checkArgument((maxRetries >= 0 ? 1 : 0) != 0, (Object)("'" + MAX_RETRIES.key() + "' value must be greater than or equal to 0"));
    }
}

