/*
 * Decompiled with CFR 0.152.
 */
package ai.dat.llm.anthropic;

import ai.dat.core.configuration.ConfigOption;
import ai.dat.core.configuration.ConfigOptions;
import ai.dat.core.configuration.ReadableConfig;
import ai.dat.core.factories.ChatModelFactory;
import ai.dat.core.factories.Factory;
import ai.dat.core.utils.FactoryUtil;
import com.google.common.base.Preconditions;
import dev.langchain4j.model.anthropic.AnthropicChatModel;
import dev.langchain4j.model.anthropic.AnthropicChatModelName;
import dev.langchain4j.model.anthropic.AnthropicStreamingChatModel;
import dev.langchain4j.model.chat.ChatModel;
import dev.langchain4j.model.chat.StreamingChatModel;
import java.time.Duration;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class AnthropicChatModelFactory
implements ChatModelFactory {
    public static final String IDENTIFIER = "anthropic";
    public static final ConfigOption<String> BASE_URL = ConfigOptions.key((String)"base-url").stringType().noDefaultValue().withDescription("The base URL of Anthropic server.");
    public static final ConfigOption<String> API_KEY = ConfigOptions.key((String)"api-key").stringType().noDefaultValue().withDescription("The API KEY of Anthropic server.");
    public static final ConfigOption<String> MODEL_NAME = ConfigOptions.key((String)"model-name").stringType().defaultValue((Object)AnthropicChatModelName.CLAUDE_SONNET_4_20250514.toString()).withDescription("The name of the model to use from Anthropic server. \nFor example: " + Arrays.stream(AnthropicChatModelName.values()).map(AnthropicChatModelName::toString).collect(Collectors.joining(", ")) + ", etc.");
    public static final ConfigOption<Double> TEMPERATURE = ConfigOptions.key((String)"temperature").doubleType().noDefaultValue().withDescription("Controls the randomness of the generated responses. Higher values (e.g., 1.0) result in more diverse output, while lower values (e.g., 0.2) produce more deterministic responses.");
    public static final ConfigOption<Integer> TOP_K = ConfigOptions.key((String)"top-k").intType().noDefaultValue().withDescription("Specifies the number of highest probability tokens to consider for each step during generation.");
    public static final ConfigOption<Double> TOP_P = ConfigOptions.key((String)"top-p").doubleType().noDefaultValue().withDescription("Controls the diversity of the generated responses by setting a threshold for the cumulative probability of top tokens.");
    public static final ConfigOption<Duration> TIMEOUT = ConfigOptions.key((String)"timeout").durationType().noDefaultValue().withDescription("The maximum time allowed for the API call to complete.");
    public static final ConfigOption<Integer> MAX_RETRIES = ConfigOptions.key((String)"max-retries").intType().defaultValue((Object)2).withDescription("The maximum number of retries in case of API call failure.");
    public static final ConfigOption<Integer> MAX_TOKENS = ConfigOptions.key((String)"max-tokens").intType().defaultValue((Object)4096).withDescription("Anthropic LLM model maximum tokens");
    public static final ConfigOption<Boolean> LOG_REQUESTS = ConfigOptions.key((String)"log-requests").booleanType().defaultValue((Object)false).withDescription("Whether to print the LLM requests log");
    public static final ConfigOption<Boolean> LOG_RESPONSES = ConfigOptions.key((String)"log-responses").booleanType().defaultValue((Object)false).withDescription("Whether to print the LLM responses log");
    public static final ConfigOption<String> VERSION = ConfigOptions.key((String)"version").stringType().noDefaultValue().withDescription("Anthropic version");
    public static final ConfigOption<String> BETA = ConfigOptions.key((String)"beta").stringType().noDefaultValue().withDescription("Anthropic beta. To use caching, please set to \"prompt-caching-2024-07-31\".");
    public static final ConfigOption<Boolean> CACHE_SYSTEM_MESSAGES = ConfigOptions.key((String)"cache-system-messages").booleanType().defaultValue((Object)false).withDescription("Whether to cache system messages");
    public static final ConfigOption<Boolean> CACHE_TOOLS = ConfigOptions.key((String)"cache-tools").booleanType().defaultValue((Object)false).withDescription("Whether to cache tools");
    public static final ConfigOption<String> THINKING_TYPE = ConfigOptions.key((String)"thinking-type").stringType().noDefaultValue().withDescription("Anthropic LLM model thinking type. To turn on extended thinking, please set to \"enabled\".");
    public static final ConfigOption<Integer> THINKING_BUDGET_TOKENS = ConfigOptions.key((String)"thinking-budget-tokens").intType().noDefaultValue().withDescription("Anthropic LLM model thinking budget tokens. After enabling thinking, and please set to a specified token budget for extended thinking.");
    public static final ConfigOption<Boolean> RETURN_THINKING = ConfigOptions.key((String)"return-thinking").booleanType().defaultValue((Object)false).withDescription("Whether to return thinking.");
    public static final ConfigOption<Boolean> SEND_THINKING = ConfigOptions.key((String)"send-thinking").booleanType().defaultValue((Object)true).withDescription("Controls whether to send thinking and signatures stored in AiMessage to the LLM in follow-up requests.");

    public String factoryIdentifier() {
        return IDENTIFIER;
    }

    public Set<ConfigOption<?>> requiredOptions() {
        return new LinkedHashSet(List.of(BASE_URL, MODEL_NAME, API_KEY));
    }

    public Set<ConfigOption<?>> optionalOptions() {
        return new LinkedHashSet(List.of(TEMPERATURE, TOP_P, TOP_K, TIMEOUT, MAX_RETRIES, MAX_TOKENS, LOG_REQUESTS, LOG_RESPONSES, VERSION, BETA, CACHE_SYSTEM_MESSAGES, CACHE_TOOLS, THINKING_TYPE, THINKING_BUDGET_TOKENS, RETURN_THINKING, SEND_THINKING));
    }

    public ChatModel create(ReadableConfig config) {
        FactoryUtil.validateFactoryOptions((Factory)this, (ReadableConfig)config);
        this.validateConfigOptions(config);
        String modelName = (String)config.get(MODEL_NAME);
        AnthropicChatModel.AnthropicChatModelBuilder builder = AnthropicChatModel.builder().modelName(modelName);
        config.getOptional(BASE_URL).ifPresent(arg_0 -> ((AnthropicChatModel.AnthropicChatModelBuilder)builder).baseUrl(arg_0));
        config.getOptional(API_KEY).ifPresent(arg_0 -> ((AnthropicChatModel.AnthropicChatModelBuilder)builder).apiKey(arg_0));
        config.getOptional(TEMPERATURE).ifPresent(arg_0 -> ((AnthropicChatModel.AnthropicChatModelBuilder)builder).temperature(arg_0));
        config.getOptional(TOP_P).ifPresent(arg_0 -> ((AnthropicChatModel.AnthropicChatModelBuilder)builder).topP(arg_0));
        config.getOptional(TOP_K).ifPresent(arg_0 -> ((AnthropicChatModel.AnthropicChatModelBuilder)builder).topK(arg_0));
        config.getOptional(TIMEOUT).ifPresent(arg_0 -> ((AnthropicChatModel.AnthropicChatModelBuilder)builder).timeout(arg_0));
        config.getOptional(MAX_RETRIES).ifPresent(arg_0 -> ((AnthropicChatModel.AnthropicChatModelBuilder)builder).maxRetries(arg_0));
        config.getOptional(MAX_TOKENS).ifPresent(arg_0 -> ((AnthropicChatModel.AnthropicChatModelBuilder)builder).maxTokens(arg_0));
        config.getOptional(LOG_REQUESTS).ifPresent(arg_0 -> ((AnthropicChatModel.AnthropicChatModelBuilder)builder).logRequests(arg_0));
        config.getOptional(LOG_RESPONSES).ifPresent(arg_0 -> ((AnthropicChatModel.AnthropicChatModelBuilder)builder).logResponses(arg_0));
        config.getOptional(VERSION).ifPresent(arg_0 -> ((AnthropicChatModel.AnthropicChatModelBuilder)builder).version(arg_0));
        config.getOptional(BETA).ifPresent(arg_0 -> ((AnthropicChatModel.AnthropicChatModelBuilder)builder).beta(arg_0));
        config.getOptional(CACHE_SYSTEM_MESSAGES).ifPresent(arg_0 -> ((AnthropicChatModel.AnthropicChatModelBuilder)builder).cacheSystemMessages(arg_0));
        config.getOptional(CACHE_TOOLS).ifPresent(arg_0 -> ((AnthropicChatModel.AnthropicChatModelBuilder)builder).cacheTools(arg_0));
        config.getOptional(THINKING_TYPE).ifPresent(arg_0 -> ((AnthropicChatModel.AnthropicChatModelBuilder)builder).thinkingType(arg_0));
        config.getOptional(THINKING_BUDGET_TOKENS).ifPresent(arg_0 -> ((AnthropicChatModel.AnthropicChatModelBuilder)builder).thinkingBudgetTokens(arg_0));
        config.getOptional(RETURN_THINKING).ifPresent(arg_0 -> ((AnthropicChatModel.AnthropicChatModelBuilder)builder).returnThinking(arg_0));
        config.getOptional(SEND_THINKING).ifPresent(arg_0 -> ((AnthropicChatModel.AnthropicChatModelBuilder)builder).sendThinking(arg_0));
        return builder.build();
    }

    public StreamingChatModel createStream(ReadableConfig config) {
        FactoryUtil.validateFactoryOptions((Factory)this, (ReadableConfig)config);
        this.validateConfigOptions(config);
        String modelName = (String)config.get(MODEL_NAME);
        AnthropicStreamingChatModel.AnthropicStreamingChatModelBuilder builder = AnthropicStreamingChatModel.builder().modelName(modelName);
        config.getOptional(BASE_URL).ifPresent(arg_0 -> ((AnthropicStreamingChatModel.AnthropicStreamingChatModelBuilder)builder).baseUrl(arg_0));
        config.getOptional(API_KEY).ifPresent(arg_0 -> ((AnthropicStreamingChatModel.AnthropicStreamingChatModelBuilder)builder).apiKey(arg_0));
        config.getOptional(TEMPERATURE).ifPresent(arg_0 -> ((AnthropicStreamingChatModel.AnthropicStreamingChatModelBuilder)builder).temperature(arg_0));
        config.getOptional(TOP_P).ifPresent(arg_0 -> ((AnthropicStreamingChatModel.AnthropicStreamingChatModelBuilder)builder).topP(arg_0));
        config.getOptional(TOP_K).ifPresent(arg_0 -> ((AnthropicStreamingChatModel.AnthropicStreamingChatModelBuilder)builder).topK(arg_0));
        config.getOptional(TIMEOUT).ifPresent(arg_0 -> ((AnthropicStreamingChatModel.AnthropicStreamingChatModelBuilder)builder).timeout(arg_0));
        config.getOptional(MAX_TOKENS).ifPresent(arg_0 -> ((AnthropicStreamingChatModel.AnthropicStreamingChatModelBuilder)builder).maxTokens(arg_0));
        config.getOptional(LOG_REQUESTS).ifPresent(arg_0 -> ((AnthropicStreamingChatModel.AnthropicStreamingChatModelBuilder)builder).logRequests(arg_0));
        config.getOptional(LOG_RESPONSES).ifPresent(arg_0 -> ((AnthropicStreamingChatModel.AnthropicStreamingChatModelBuilder)builder).logResponses(arg_0));
        config.getOptional(VERSION).ifPresent(arg_0 -> ((AnthropicStreamingChatModel.AnthropicStreamingChatModelBuilder)builder).version(arg_0));
        config.getOptional(BETA).ifPresent(arg_0 -> ((AnthropicStreamingChatModel.AnthropicStreamingChatModelBuilder)builder).beta(arg_0));
        config.getOptional(CACHE_SYSTEM_MESSAGES).ifPresent(arg_0 -> ((AnthropicStreamingChatModel.AnthropicStreamingChatModelBuilder)builder).cacheSystemMessages(arg_0));
        config.getOptional(CACHE_TOOLS).ifPresent(arg_0 -> ((AnthropicStreamingChatModel.AnthropicStreamingChatModelBuilder)builder).cacheTools(arg_0));
        config.getOptional(THINKING_TYPE).ifPresent(arg_0 -> ((AnthropicStreamingChatModel.AnthropicStreamingChatModelBuilder)builder).thinkingType(arg_0));
        config.getOptional(THINKING_BUDGET_TOKENS).ifPresent(arg_0 -> ((AnthropicStreamingChatModel.AnthropicStreamingChatModelBuilder)builder).thinkingBudgetTokens(arg_0));
        config.getOptional(RETURN_THINKING).ifPresent(arg_0 -> ((AnthropicStreamingChatModel.AnthropicStreamingChatModelBuilder)builder).returnThinking(arg_0));
        config.getOptional(SEND_THINKING).ifPresent(arg_0 -> ((AnthropicStreamingChatModel.AnthropicStreamingChatModelBuilder)builder).sendThinking(arg_0));
        return builder.build();
    }

    private void validateConfigOptions(ReadableConfig config) {
        config.getOptional(TEMPERATURE).ifPresent(t -> Preconditions.checkArgument((t >= 0.0 && t <= 2.0 ? 1 : 0) != 0, (Object)("'" + TEMPERATURE.key() + "' value must be between 0.0 and 2.0")));
        config.getOptional(TOP_P).ifPresent(v -> Preconditions.checkArgument((v > 0.0 && v <= 1.0 ? 1 : 0) != 0, (Object)("'" + TOP_P.key() + "' value must > 0.0 and <= 1.0")));
        config.getOptional(TOP_K).ifPresent(v -> Preconditions.checkArgument((v >= 1 ? 1 : 0) != 0, (Object)("'" + TOP_K.key() + "' value must be greater than 1")));
        Integer maxRetries = (Integer)config.get(MAX_RETRIES);
        Preconditions.checkArgument((maxRetries >= 0 ? 1 : 0) != 0, (Object)("'" + MAX_RETRIES.key() + "' value must be greater than or equal to 0"));
        Integer maxTokens = (Integer)config.get(MAX_TOKENS);
        Preconditions.checkArgument((maxTokens > 0 ? 1 : 0) != 0, (Object)("'" + MAX_TOKENS.key() + "' value must be greater than 0"));
    }
}

