/*
 * Decompiled with CFR 0.152.
 */
package ai.dat.embedder.ollama;

import ai.dat.core.configuration.ConfigOption;
import ai.dat.core.configuration.ConfigOptions;
import ai.dat.core.configuration.ReadableConfig;
import ai.dat.core.factories.EmbeddingModelFactory;
import ai.dat.core.factories.Factory;
import ai.dat.core.utils.FactoryUtil;
import com.google.common.base.Preconditions;
import dev.langchain4j.model.embedding.EmbeddingModel;
import dev.langchain4j.model.ollama.OllamaEmbeddingModel;
import java.time.Duration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OllamaEmbeddingModelFactory
implements EmbeddingModelFactory {
    public static final String IDENTIFIER = "ollama";
    public static final ConfigOption<String> BASE_URL = ConfigOptions.key((String)"base-url").stringType().defaultValue((Object)"http://localhost:11434").withDescription("The base URL of Ollama server.");
    public static final ConfigOption<String> MODEL_NAME = ConfigOptions.key((String)"model-name").stringType().noDefaultValue().withDescription("The name of the embedding model to use from Ollama server.");
    public static final ConfigOption<Duration> TIMEOUT = ConfigOptions.key((String)"timeout").durationType().noDefaultValue().withDescription("The maximum time allowed for the API call to complete.");
    public static final ConfigOption<Integer> MAX_RETRIES = ConfigOptions.key((String)"max-retries").intType().defaultValue((Object)2).withDescription("The maximum number of retries in case of API call failure.");
    public static final ConfigOption<Boolean> LOG_REQUESTS = ConfigOptions.key((String)"log-requests").booleanType().defaultValue((Object)false).withDescription("Whether to print the embedding model requests log");
    public static final ConfigOption<Boolean> LOG_RESPONSES = ConfigOptions.key((String)"log-responses").booleanType().defaultValue((Object)false).withDescription("Whether to print the embedding model responses log");
    public static final ConfigOption<Map<String, String>> CUSTOM_HEADERS = ConfigOptions.key((String)"custom-headers").mapType().noDefaultValue().withDescription("Custom HTTP headers. For example: {\"content-type\": \"application/json\", \"accept\": \"application/json, text/event-stream\"}");

    public String factoryIdentifier() {
        return IDENTIFIER;
    }

    public Set<ConfigOption<?>> requiredOptions() {
        return new LinkedHashSet(List.of(BASE_URL, MODEL_NAME));
    }

    public Set<ConfigOption<?>> optionalOptions() {
        return new LinkedHashSet(List.of(TIMEOUT, MAX_RETRIES, LOG_REQUESTS, LOG_RESPONSES, CUSTOM_HEADERS));
    }

    public Set<ConfigOption<?>> fingerprintOptions() {
        return Set.of(MODEL_NAME, BASE_URL);
    }

    public EmbeddingModel create(ReadableConfig config) {
        FactoryUtil.validateFactoryOptions((Factory)this, (ReadableConfig)config);
        this.validateConfigOptions(config);
        String baseUrl = (String)config.get(BASE_URL);
        String modelName = (String)config.get(MODEL_NAME);
        Boolean logRequests = (Boolean)config.get(LOG_REQUESTS);
        Boolean logResponses = (Boolean)config.get(LOG_RESPONSES);
        OllamaEmbeddingModel.OllamaEmbeddingModelBuilder builder = OllamaEmbeddingModel.builder().baseUrl(baseUrl).modelName(modelName).logRequests(logRequests).logResponses(logResponses);
        config.getOptional(TIMEOUT).ifPresent(arg_0 -> ((OllamaEmbeddingModel.OllamaEmbeddingModelBuilder)builder).timeout(arg_0));
        config.getOptional(MAX_RETRIES).ifPresent(arg_0 -> ((OllamaEmbeddingModel.OllamaEmbeddingModelBuilder)builder).maxRetries(arg_0));
        config.getOptional(CUSTOM_HEADERS).ifPresent(arg_0 -> ((OllamaEmbeddingModel.OllamaEmbeddingModelBuilder)builder).customHeaders(arg_0));
        return builder.build();
    }

    private void validateConfigOptions(ReadableConfig config) {
        Integer maxRetries = (Integer)config.get(MAX_RETRIES);
        Preconditions.checkArgument((maxRetries >= 0 ? 1 : 0) != 0, (Object)("'" + MAX_RETRIES.key() + "' value must be greater than or equal to 0"));
    }
}

