/*
 * Decompiled with CFR 0.152.
 */
package ai.dat.adapter.mysql;

import ai.dat.adapter.mysql.DatMysqlSqlDialect;
import ai.dat.core.adapter.SemanticAdapter;
import ai.dat.core.adapter.data.AnsiSqlType;
import ai.dat.core.semantic.data.Dimension;
import org.apache.calcite.sql.SqlDialect;

public class MySqlSemanticAdapter
implements SemanticAdapter {
    public static final SqlDialect DEFAULT = new DatMysqlSqlDialect(DatMysqlSqlDialect.DEFAULT_CONTEXT.withIdentifierQuoteString(""));

    public SqlDialect getSqlDialect() {
        return DEFAULT;
    }

    public String applyTimeGranularity(String dateExpr, Dimension.TypeParams.TimeGranularity granularity) {
        if (dateExpr == null || dateExpr.trim().isEmpty()) {
            throw new IllegalArgumentException("Date expression cannot be null or empty");
        }
        return switch (granularity) {
            default -> throw new IncompatibleClassChangeError();
            case Dimension.TypeParams.TimeGranularity.YEAR -> "DATE_FORMAT(" + dateExpr + ", '%Y-01-01')";
            case Dimension.TypeParams.TimeGranularity.QUARTER -> "CASE QUARTER(" + dateExpr + ") WHEN 1 THEN CONCAT(YEAR(" + dateExpr + "), '-01-01') WHEN 2 THEN CONCAT(YEAR(" + dateExpr + "), '-04-01') WHEN 3 THEN CONCAT(YEAR(" + dateExpr + "), '-07-01') WHEN 4 THEN CONCAT(YEAR(" + dateExpr + "), '-10-01') END";
            case Dimension.TypeParams.TimeGranularity.MONTH -> "DATE_FORMAT(" + dateExpr + ", '%Y-%m-01')";
            case Dimension.TypeParams.TimeGranularity.WEEK -> "DATE_SUB(" + dateExpr + ", INTERVAL WEEKDAY(" + dateExpr + ") DAY)";
            case Dimension.TypeParams.TimeGranularity.DAY -> "DATE_FORMAT(" + dateExpr + ", '%Y-%m-%d')";
            case Dimension.TypeParams.TimeGranularity.HOUR -> "DATE_FORMAT(" + dateExpr + ", '%Y-%m-%d %H:00:00')";
            case Dimension.TypeParams.TimeGranularity.MINUTE -> "DATE_FORMAT(" + dateExpr + ", '%Y-%m-%d %H:%i:00')";
            case Dimension.TypeParams.TimeGranularity.SECOND -> "DATE_FORMAT(" + dateExpr + ", '%Y-%m-%d %H:%i:%s')";
        };
    }

    public AnsiSqlType toAnsiSqlType(String columnTypeName) {
        return switch (columnTypeName.toUpperCase()) {
            case "TINYINT" -> AnsiSqlType.BOOLEAN;
            case "SMALLINT" -> AnsiSqlType.SMALLINT;
            case "MEDIUMINT" -> AnsiSqlType.INTEGER;
            case "INT", "INTEGER" -> AnsiSqlType.INTEGER;
            case "BIGINT" -> AnsiSqlType.BIGINT;
            case "DECIMAL", "DEC", "NUMERIC" -> AnsiSqlType.DECIMAL;
            case "FLOAT" -> AnsiSqlType.FLOAT;
            case "DOUBLE", "DOUBLE PRECISION", "REAL" -> AnsiSqlType.DOUBLE;
            case "BIT" -> AnsiSqlType.BOOLEAN;
            case "BOOL", "BOOLEAN" -> AnsiSqlType.BOOLEAN;
            case "CHAR" -> AnsiSqlType.CHAR;
            case "VARCHAR" -> AnsiSqlType.VARCHAR;
            case "TEXT", "TINYTEXT", "MEDIUMTEXT", "LONGTEXT" -> AnsiSqlType.TEXT;
            case "BINARY" -> AnsiSqlType.BINARY;
            case "VARBINARY" -> AnsiSqlType.VARBINARY;
            case "BLOB", "TINYBLOB", "MEDIUMBLOB", "LONGBLOB" -> AnsiSqlType.BLOB;
            case "DATE" -> AnsiSqlType.DATE;
            case "TIME" -> AnsiSqlType.TIME;
            case "DATETIME", "TIMESTAMP" -> AnsiSqlType.TIMESTAMP;
            case "YEAR" -> AnsiSqlType.SMALLINT;
            case "JSON" -> AnsiSqlType.TEXT;
            case "GEOMETRY", "POINT", "LINESTRING", "POLYGON", "MULTIPOINT", "MULTILINESTRING", "MULTIPOLYGON", "GEOMETRYCOLLECTION" -> AnsiSqlType.VARBINARY;
            default -> AnsiSqlType.UNKNOWN;
        };
    }
}

