/*
 * Decompiled with CFR 0.152.
 */
package ai.dat.adapter.mysql;

import ai.dat.adapter.mysql.MySqlDatabaseAdapter;
import ai.dat.core.adapter.DatabaseAdapter;
import ai.dat.core.configuration.ConfigOption;
import ai.dat.core.configuration.ConfigOptions;
import ai.dat.core.configuration.ReadableConfig;
import ai.dat.core.factories.DatabaseAdapterFactory;
import com.mysql.cj.jdbc.MysqlDataSource;
import java.sql.SQLException;
import java.time.Duration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.sql.DataSource;

public class MySqlDatabaseAdapterFactory
implements DatabaseAdapterFactory {
    public static final String IDENTIFIER = "mysql";
    public static final ConfigOption<String> URL = ConfigOptions.key((String)"url").stringType().noDefaultValue().withDescription("MySQL JDBC URL");
    public static final ConfigOption<String> USERNAME = ConfigOptions.key((String)"username").stringType().noDefaultValue().withDescription("MySQL user name");
    public static final ConfigOption<String> PASSWORD = ConfigOptions.key((String)"password").stringType().noDefaultValue().withDescription("MySQL password");
    public static final ConfigOption<Duration> TIMEOUT = ConfigOptions.key((String)"timeout").durationType().defaultValue((Object)Duration.ofSeconds(60L)).withDescription("MySQL maximum timeout. The timeout should be in millisecond granularity.");

    public String factoryIdentifier() {
        return IDENTIFIER;
    }

    public Set<ConfigOption<?>> requiredOptions() {
        return new LinkedHashSet(List.of(URL, USERNAME, PASSWORD));
    }

    public Set<ConfigOption<?>> optionalOptions() {
        return new LinkedHashSet(List.of(TIMEOUT));
    }

    public DatabaseAdapter create(ReadableConfig config) {
        String url = (String)config.get(URL);
        Duration timeout = (Duration)config.get(TIMEOUT);
        try {
            MysqlDataSource dataSource = new MysqlDataSource();
            dataSource.setURL(url);
            config.getOptional(USERNAME).ifPresent(arg_0 -> ((MysqlDataSource)dataSource).setUser(arg_0));
            config.getOptional(PASSWORD).ifPresent(arg_0 -> ((MysqlDataSource)dataSource).setPassword(arg_0));
            dataSource.setConnectTimeout((int)timeout.toMillis());
            return new MySqlDatabaseAdapter((DataSource)dataSource);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

