/*
 * Decompiled with CFR 0.152.
 */
package ai.dat.adapter.mysql;

import ai.dat.adapter.mysql.MySqlSemanticAdapter;
import ai.dat.core.adapter.GenericSqlDatabaseAdapter;
import ai.dat.core.adapter.SemanticAdapter;
import ai.dat.core.adapter.data.AnsiSqlType;
import java.sql.Timestamp;
import javax.sql.DataSource;

public class MySqlDatabaseAdapter
extends GenericSqlDatabaseAdapter {
    public MySqlDatabaseAdapter(DataSource dataSource) {
        super((SemanticAdapter)new MySqlSemanticAdapter(), dataSource);
    }

    protected Object handleSpecificTypes(Object value, int columnType) {
        if (value == null) {
            return null;
        }
        switch (columnType) {
            case -7: {
                if (value instanceof Boolean) {
                    return value;
                }
                if (!(value instanceof byte[])) break;
                byte[] bytes = (byte[])value;
                return bytes.length > 0 && bytes[0] != 0;
            }
            case -6: {
                if (!(value instanceof Number)) break;
                int intValue = ((Number)value).intValue();
                return intValue != 0;
            }
            case 93: {
                if (!(value instanceof Timestamp)) break;
                return value;
            }
        }
        return value;
    }

    public AnsiSqlType toAnsiSqlType(int columnType, String columnTypeName, int precision, int scale) {
        return switch (columnTypeName.toUpperCase()) {
            case "TINYINT" -> {
                if (precision == 1) {
                    yield AnsiSqlType.BOOLEAN;
                }
                yield AnsiSqlType.TINYINT;
            }
            case "SMALLINT" -> AnsiSqlType.SMALLINT;
            case "MEDIUMINT" -> AnsiSqlType.INTEGER;
            case "INT", "INTEGER" -> AnsiSqlType.INTEGER;
            case "BIGINT" -> AnsiSqlType.BIGINT;
            case "DECIMAL", "DEC", "NUMERIC" -> AnsiSqlType.DECIMAL;
            case "FLOAT" -> AnsiSqlType.FLOAT;
            case "DOUBLE", "DOUBLE PRECISION", "REAL" -> AnsiSqlType.DOUBLE;
            case "BIT" -> AnsiSqlType.BOOLEAN;
            case "BOOL", "BOOLEAN" -> AnsiSqlType.BOOLEAN;
            case "CHAR" -> AnsiSqlType.CHAR;
            case "VARCHAR" -> AnsiSqlType.VARCHAR;
            case "TEXT", "TINYTEXT", "MEDIUMTEXT", "LONGTEXT" -> AnsiSqlType.TEXT;
            case "BINARY" -> AnsiSqlType.BINARY;
            case "VARBINARY" -> AnsiSqlType.VARBINARY;
            case "BLOB", "TINYBLOB", "MEDIUMBLOB", "LONGBLOB" -> AnsiSqlType.BLOB;
            case "DATE" -> AnsiSqlType.DATE;
            case "TIME" -> AnsiSqlType.TIME;
            case "DATETIME", "TIMESTAMP" -> AnsiSqlType.TIMESTAMP;
            case "YEAR" -> AnsiSqlType.SMALLINT;
            case "JSON" -> AnsiSqlType.TEXT;
            case "GEOMETRY", "POINT", "LINESTRING", "POLYGON", "MULTIPOINT", "MULTILINESTRING", "MULTIPOLYGON", "GEOMETRYCOLLECTION" -> AnsiSqlType.VARBINARY;
            default -> super.toAnsiSqlType(columnType, columnTypeName, precision, scale);
        };
    }

    protected String stringDataType() {
        return "TEXT";
    }

    protected int toColumnType(String dataType) {
        if (dataType == null) {
            return 12;
        }
        return switch (this.extractBaseType(dataType).toUpperCase()) {
            case "TINYINT" -> -6;
            case "SMALLINT", "YEAR" -> 5;
            case "MEDIUMINT", "INT", "INTEGER" -> 4;
            case "BIGINT" -> -5;
            case "DECIMAL", "DEC", "NUMERIC", "FIXED" -> 3;
            case "FLOAT" -> 6;
            case "DOUBLE", "DOUBLE PRECISION", "REAL" -> 8;
            case "BIT", "BOOL", "BOOLEAN" -> 16;
            case "CHAR" -> 1;
            case "VARCHAR" -> 12;
            case "TINYTEXT", "TEXT", "MEDIUMTEXT", "LONGTEXT", "JSON" -> -1;
            case "BINARY" -> -2;
            case "VARBINARY" -> -3;
            case "TINYBLOB", "BLOB", "MEDIUMBLOB", "LONGBLOB" -> 2004;
            case "DATE" -> 91;
            case "TIME" -> 92;
            case "DATETIME", "TIMESTAMP" -> 93;
            case "ENUM", "SET" -> 12;
            case "GEOMETRY", "POINT", "LINESTRING", "POLYGON", "MULTIPOINT", "MULTILINESTRING", "MULTIPOLYGON", "GEOMETRYCOLLECTION" -> -3;
            default -> 12;
        };
    }

    private String extractBaseType(String dataType) {
        int parenIndex = dataType.indexOf(40);
        if (parenIndex == -1) {
            return dataType;
        }
        return dataType.substring(0, parenIndex).trim();
    }

    public String limitClause(int limit) {
        return "LIMIT " + limit;
    }
}

