/*
 * Decompiled with CFR 0.152.
 */
package cn.daimaxia.framework.web.core.util;

import cn.daimaxia.framework.common.util.web.response.Result;
import cn.daimaxia.framework.satoken.core.UserInfo;
import cn.daimaxia.framework.satoken.core.util.SaTokenUtils;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.springframework.boot.autoconfigure.web.WebProperties;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class WebFrameworkUtils {
    private static final String REQUEST_ATTRIBUTE_LOGIN_USER_TYPE = "login_user_type";
    private static final String REQUEST_ATTRIBUTE_COMMON_RESULT = "common_result";
    private static WebProperties properties;

    public WebFrameworkUtils(WebProperties webProperties) {
        properties = webProperties;
    }

    public static void setLoginUserType(ServletRequest request, Integer userType) {
        request.setAttribute(REQUEST_ATTRIBUTE_LOGIN_USER_TYPE, (Object)userType);
    }

    public static Object getLoginUserId() {
        return SaTokenUtils.getLoginId();
    }

    public static Boolean isLogin() {
        return SaTokenUtils.isLogin();
    }

    public static void login(Object loginId, UserInfo userInfo) {
        SaTokenUtils.login((Object)loginId, (UserInfo)userInfo);
    }

    public static UserInfo getLoginUserInfo() {
        return SaTokenUtils.getLoginUserInfo();
    }

    public static void setCommonResult(ServletRequest request, Result<?> result) {
        request.setAttribute(REQUEST_ATTRIBUTE_COMMON_RESULT, result);
    }

    public static Result<?> getCommonResult(ServletRequest request) {
        return (Result)request.getAttribute(REQUEST_ATTRIBUTE_COMMON_RESULT);
    }

    private static HttpServletRequest getRequest() {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (!(requestAttributes instanceof ServletRequestAttributes)) {
            return null;
        }
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)requestAttributes;
        return servletRequestAttributes.getRequest();
    }
}

