package cn.daimaxia.framework.datasource.core.annotation;

import org.springframework.stereotype.Component;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 用于补充：Hibernate没法自动建立视图的缺陷。
 * 系统启动时(hibernate根据entity建立完基本的数据表后)，开始执行本注解下的sql文件中的SQL语言。
 * 使用方法：
 * @InitDataSource("sql文件路径(相对于resources路径下)")  ---- 注解到对应的类上
 * 好比：@InitDataSource("db/view/createView.sql)")
 * 使用示例请参见：ResourceApplication.java
 * 预了解详细的实现过程请参考：WebConfig.java 的 dataSourceInitializer方法
 * @author huangtingxiang
 */
@Target({ElementType.TYPE})     // 该注解用于类上
@Retention(RetentionPolicy.RUNTIME) // 在运行时起做用
@Component
public @interface InitDataSource {
    String[] value();
}