package cn.daimaxia.framework.common.util.web.response.module;

import lombok.Getter;
import lombok.Setter;

/**
 * 描述: 前 端 表 格 数 据 封 装
 * Class: ResultTable
 * Author: zc
 * Date: 2021/3/31 2:47 下午
 **/
@Getter
@Setter
public class ResultTable  {

    /**
     * 状态码
     */
    private Integer code;

    /**
     * 提示消息
     */
    private String msg;

    /**
     * 消息总量
     */
    private Long count;

    /**
     * 合计栏数据
     */
    private Object totalRow;
    /**
     * 数据对象
     */
    private Object data;

    /**
     * 构 建
     */
    public static ResultTable pageTable(long count, Object data) {
        ResultTable resultTable = new ResultTable();
        resultTable.setData(data);
        resultTable.setCode(0);
        resultTable.setCount(count);
        return resultTable;
    }
    /**
     * 构 建
     */
    public static ResultTable pageTable( Object data,long count, Object totalRow) {
        ResultTable resultTable = new ResultTable();
        resultTable.setData(data);
        resultTable.setCode(0);
        resultTable.setCount(count);
        resultTable.setTotalRow(totalRow);
        return resultTable;
    }

    public static ResultTable dataTable(Object data) {
        ResultTable resultTable = new ResultTable();
        resultTable.setData(data);
        resultTable.setCode(0);
        return resultTable;
    }

}
