package cn.daimaxia.framework.common.util.web.request;

import lombok.Data;

/**
 * @describe:分 页 参 数 封 装
 * @author: ZY
 * @date: 2021-08-13
 */
@Data
public class PageEntity {

    /**
     * 当前页
     */
    private Integer page;

    /**
     * 每页数量
     */
    private Integer limit;

    /**
     * 获取开始的数据行
     */
    public Integer start() {
        return (this.page - 1) * this.limit;
    }

    /**
     * 获取结束的数据行
     */
    public Integer end() {
        return this.page * this.limit;
    }

}
