package cn.daimaxia.framework.common.util.common;

import cn.daimaxia.framework.common.pojo.Tree;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TreeUtils {
    public static List<Tree> toTree(List<Tree> treeList, String parentId) {

        Map<String, List<Tree>> childrenMap = new HashMap<>();
        Map<String, Tree> parentMap = new HashMap<>();
        List<Tree> res = new ArrayList<>();

        for (Tree node : treeList
        ) {
            node.setHasChildren(false);
            if (!childrenMap.containsKey(node.getParentId())) {
                childrenMap.put(node.getParentId(), new ArrayList<Tree>());
            } else if (parentMap.containsKey(node.getParentId())) {
                parentMap.get(node.getParentId()).setHasChildren(true);
            }
            childrenMap.get(node.getParentId()).add(node);
            parentMap.put(node.getId(), node);
            if (!childrenMap.containsKey(node.getId())) {
                childrenMap.put(node.getId(), new ArrayList<Tree>());
            } else {
                node.setHasChildren(true);
            }
            node.setChildren(childrenMap.get(node.getId()));
        }
        if (!StringUtils.hasLength(parentId)) {
            for (Map.Entry<String, List<Tree>> item : childrenMap.entrySet()) {
                if (!parentMap.containsKey(item.getKey())) {
                    res.addAll(item.getValue());
                }
            }
        } else {
            if (childrenMap.containsKey(parentId)) {
                return childrenMap.get(parentId);
            } else {
                return new ArrayList<>();
            }
        }

        return res;
    }

    public static List<Tree> toTree(List<Tree> treeList) {
        return toTree(treeList, "");
    }
}