/*
 * Decompiled with CFR 0.152.
 */
package cn.daimax.framework.operatelog.core.aop;

import cn.daimax.framework.common.exception.enums.GlobalErrorCodeConstants;
import cn.daimax.framework.common.util.json.JsonUtils;
import cn.daimax.framework.common.util.servlet.ServletUtils;
import cn.daimax.framework.common.util.web.response.Result;
import cn.daimax.framework.operatelog.core.entity.OperateLog;
import cn.daimax.framework.operatelog.core.enums.OperateTypeEnum;
import cn.daimax.framework.operatelog.core.service.OperateLogFrameworkService;
import cn.hutool.core.exceptions.ExceptionUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.servlet.ServletUtil;
import com.google.common.collect.Maps;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.IntStream;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.multipart.MultipartFile;

@Aspect
public class OperateLogAspect {
    private static final Logger log = LoggerFactory.getLogger(OperateLogAspect.class);
    private static final ThreadLocal<String> CONTENT = new ThreadLocal();
    private static final ThreadLocal<Map<String, Object>> EXTS = new ThreadLocal();
    @Resource
    private OperateLogFrameworkService operateLogFrameworkService;

    @Around(value="@annotation(apiOperation)")
    public Object around(ProceedingJoinPoint joinPoint, ApiOperation apiOperation) throws Throwable {
        cn.daimax.framework.operatelog.core.annotations.OperateLog operateLog = OperateLogAspect.getMethodAnnotation(joinPoint, cn.daimax.framework.operatelog.core.annotations.OperateLog.class);
        return this.around0(joinPoint, operateLog, apiOperation);
    }

    @Around(value="!@annotation(io.swagger.annotations.ApiOperation) && @annotation(operateLog)")
    public Object around(ProceedingJoinPoint joinPoint, cn.daimax.framework.operatelog.core.annotations.OperateLog operateLog) throws Throwable {
        return this.around0(joinPoint, operateLog, null);
    }

    private Object around0(ProceedingJoinPoint joinPoint, cn.daimax.framework.operatelog.core.annotations.OperateLog operateLog, ApiOperation apiOperation) throws Throwable {
        Date startTime = new Date();
        try {
            Object result = joinPoint.proceed();
            this.log(joinPoint, operateLog, apiOperation, startTime, result, null);
            Object object = result;
            return object;
        }
        catch (Throwable exception) {
            this.log(joinPoint, operateLog, apiOperation, startTime, null, exception);
            throw exception;
        }
        finally {
            OperateLogAspect.clearThreadLocal();
        }
    }

    public static void setContent(String content) {
        CONTENT.set(content);
    }

    public static void addExt(String key, Object value) {
        if (EXTS.get() == null) {
            EXTS.set(new HashMap());
        }
        EXTS.get().put(key, value);
    }

    private static void clearThreadLocal() {
        CONTENT.remove();
        EXTS.remove();
    }

    private void log(ProceedingJoinPoint joinPoint, cn.daimax.framework.operatelog.core.annotations.OperateLog operateLog, ApiOperation apiOperation, Date startTime, Object result, Throwable exception) {
        try {
            if (!OperateLogAspect.isLogEnable(joinPoint, operateLog)) {
                return;
            }
            this.log0(joinPoint, operateLog, apiOperation, startTime, result, exception);
        }
        catch (Throwable ex) {
            log.error("[log][\u8bb0\u5f55\u64cd\u4f5c\u65e5\u5fd7\u65f6\uff0c\u53d1\u751f\u5f02\u5e38\uff0c\u5176\u4e2d\u53c2\u6570\u662f joinPoint({}) operateLog({}) apiOperation({}) result({}) exception({}) ]", new Object[]{joinPoint, operateLog, apiOperation, result, exception, ex});
        }
    }

    private void log0(ProceedingJoinPoint joinPoint, cn.daimax.framework.operatelog.core.annotations.OperateLog operateLog, ApiOperation apiOperation, Date startTime, Object result, Throwable exception) {
        OperateLog operateLogObj = new OperateLog();
        operateLogObj.setStartTime(startTime);
        OperateLogAspect.fillUserFields(operateLogObj);
        OperateLogAspect.fillModuleFields(operateLogObj, joinPoint, operateLog, apiOperation);
        OperateLogAspect.fillRequestFields(operateLogObj);
        OperateLogAspect.fillMethodFields(operateLogObj, joinPoint, operateLog, startTime, result, exception);
        this.operateLogFrameworkService.createOperateLog(operateLogObj);
    }

    private static void fillUserFields(OperateLog operateLogObj) {
    }

    private static void fillModuleFields(OperateLog operateLogObj, ProceedingJoinPoint joinPoint, cn.daimax.framework.operatelog.core.annotations.OperateLog operateLog, ApiOperation apiOperation) {
        Api api;
        if (operateLog != null) {
            operateLogObj.setModule(operateLog.module());
        }
        if (StrUtil.isEmpty((CharSequence)operateLogObj.getModule()) && (api = OperateLogAspect.getClassAnnotation(joinPoint, Api.class)) != null) {
            if (StrUtil.isNotEmpty((CharSequence)api.value())) {
                operateLogObj.setModule(api.value());
            }
            if (StrUtil.isEmpty((CharSequence)operateLogObj.getModule()) && ArrayUtil.isNotEmpty((Object[])api.tags())) {
                operateLogObj.setModule(api.tags()[0]);
            }
        }
        if (operateLog != null) {
            operateLogObj.setName(operateLog.name());
        }
        if (StrUtil.isEmpty((CharSequence)operateLogObj.getName()) && apiOperation != null) {
            operateLogObj.setName(apiOperation.value());
        }
        if (operateLog != null && ArrayUtil.isNotEmpty((Object[])operateLog.type())) {
            operateLogObj.setType(operateLog.type()[0].getType());
        }
        if (operateLogObj.getType() == null) {
            RequestMethod requestMethod = OperateLogAspect.obtainFirstMatchRequestMethod(OperateLogAspect.obtainRequestMethod(joinPoint));
            OperateTypeEnum operateLogType = OperateLogAspect.convertOperateLogType(requestMethod);
            operateLogObj.setType(operateLogType != null ? operateLogType.getType() : null);
        }
        operateLogObj.setContent(CONTENT.get());
        operateLogObj.setExts(EXTS.get());
    }

    private static void fillRequestFields(OperateLog operateLogObj) {
        HttpServletRequest request = ServletUtils.getRequest();
        if (request == null) {
            return;
        }
        operateLogObj.setRequestMethod(request.getMethod());
        operateLogObj.setRequestUrl(request.getRequestURI());
        operateLogObj.setUserIp(ServletUtil.getClientIP((HttpServletRequest)request, (String[])new String[0]));
        operateLogObj.setUserAgent(ServletUtils.getUserAgent((HttpServletRequest)request));
    }

    private static void fillMethodFields(OperateLog operateLogObj, ProceedingJoinPoint joinPoint, cn.daimax.framework.operatelog.core.annotations.OperateLog operateLog, Date startTime, Object result, Throwable exception) {
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        operateLogObj.setJavaMethod(methodSignature.toString());
        if (operateLog == null || operateLog.logArgs()) {
            operateLogObj.setJavaMethodArgs(OperateLogAspect.obtainMethodArgs(joinPoint));
        }
        if (operateLog == null || operateLog.logResultData()) {
            operateLogObj.setResultData(OperateLogAspect.obtainResultData(result));
        }
        operateLogObj.setDuration((int)(System.currentTimeMillis() - startTime.getTime()));
        if (result instanceof Result) {
            Result commonResult = (Result)result;
            operateLogObj.setResultCode(commonResult.getCode());
            operateLogObj.setResultMsg(commonResult.getMsg());
        } else {
            operateLogObj.setResultCode(GlobalErrorCodeConstants.SUCCESS.getCode());
        }
        if (exception != null) {
            operateLogObj.setResultCode(GlobalErrorCodeConstants.INTERNAL_SERVER_ERROR.getCode());
            operateLogObj.setResultMsg(ExceptionUtil.getRootCauseMessage((Throwable)exception));
        }
    }

    private static boolean isLogEnable(ProceedingJoinPoint joinPoint, cn.daimax.framework.operatelog.core.annotations.OperateLog operateLog) {
        if (operateLog != null) {
            return operateLog.enable();
        }
        return OperateLogAspect.obtainFirstLogRequestMethod(OperateLogAspect.obtainRequestMethod(joinPoint)) != null;
    }

    private static RequestMethod obtainFirstLogRequestMethod(RequestMethod[] requestMethods) {
        if (ArrayUtil.isEmpty((Object[])requestMethods)) {
            return null;
        }
        return Arrays.stream(requestMethods).filter(requestMethod -> requestMethod == RequestMethod.POST || requestMethod == RequestMethod.PUT || requestMethod == RequestMethod.DELETE).findFirst().orElse(null);
    }

    private static RequestMethod obtainFirstMatchRequestMethod(RequestMethod[] requestMethods) {
        if (ArrayUtil.isEmpty((Object[])requestMethods)) {
            return null;
        }
        RequestMethod result = OperateLogAspect.obtainFirstLogRequestMethod(requestMethods);
        if (result != null) {
            return result;
        }
        result = Arrays.stream(requestMethods).filter(requestMethod -> requestMethod == RequestMethod.GET).findFirst().orElse(null);
        if (result != null) {
            return result;
        }
        return requestMethods[0];
    }

    private static OperateTypeEnum convertOperateLogType(RequestMethod requestMethod) {
        if (requestMethod == null) {
            return null;
        }
        switch (requestMethod) {
            case GET: {
                return OperateTypeEnum.GET;
            }
            case POST: {
                return OperateTypeEnum.CREATE;
            }
            case PUT: {
                return OperateTypeEnum.UPDATE;
            }
            case DELETE: {
                return OperateTypeEnum.DELETE;
            }
        }
        return OperateTypeEnum.OTHER;
    }

    private static RequestMethod[] obtainRequestMethod(ProceedingJoinPoint joinPoint) {
        RequestMapping requestMapping = (RequestMapping)AnnotationUtils.getAnnotation((Method)((MethodSignature)joinPoint.getSignature()).getMethod(), RequestMapping.class);
        return requestMapping != null ? requestMapping.method() : new RequestMethod[]{};
    }

    private static <T extends Annotation> T getMethodAnnotation(ProceedingJoinPoint joinPoint, Class<T> annotationClass) {
        return ((MethodSignature)joinPoint.getSignature()).getMethod().getAnnotation(annotationClass);
    }

    private static <T extends Annotation> T getClassAnnotation(ProceedingJoinPoint joinPoint, Class<T> annotationClass) {
        return ((MethodSignature)joinPoint.getSignature()).getMethod().getDeclaringClass().getAnnotation(annotationClass);
    }

    private static String obtainMethodArgs(ProceedingJoinPoint joinPoint) {
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        String[] argNames = methodSignature.getParameterNames();
        Object[] argValues = joinPoint.getArgs();
        HashMap args = Maps.newHashMapWithExpectedSize((int)argValues.length);
        for (int i = 0; i < argNames.length; ++i) {
            String argName = argNames[i];
            Object argValue = argValues[i];
            args.put(argName, !OperateLogAspect.isIgnoreArgs(argValue) ? argValue : "[ignore]");
        }
        return JsonUtils.toJsonString((Object)args);
    }

    private static String obtainResultData(Object result) {
        if (result instanceof Result) {
            result = ((Result)result).getData();
        }
        return JsonUtils.toJsonString((Object)result);
    }

    private static boolean isIgnoreArgs(Object object) {
        Class<?> clazz = object.getClass();
        if (clazz.isArray()) {
            return IntStream.range(0, Array.getLength(object)).anyMatch(index -> OperateLogAspect.isIgnoreArgs(Array.get(object, index)));
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            return ((Collection)object).stream().anyMatch(OperateLogAspect::isIgnoreArgs);
        }
        if (Map.class.isAssignableFrom(clazz)) {
            return OperateLogAspect.isIgnoreArgs(((Map)object).values());
        }
        return object instanceof MultipartFile || object instanceof HttpServletRequest || object instanceof HttpServletResponse || object instanceof BindingResult;
    }
}

