/*
 * Decompiled with CFR 0.152.
 */
package cn.daenx.yhchatsdk.framework.core;

import cn.daenx.yhchatsdk.common.constant.enums.EventType;
import cn.daenx.yhchatsdk.framework.core.GlobalPluginHandel;
import cn.daenx.yhchatsdk.framework.vo.EventMsgVo;
import cn.daenx.yhchatsdk.framework.vo.PluginManagerVo;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalEventHandle
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(GlobalEventHandle.class);
    private static GlobalPluginHandel globalPluginHandel;
    private EventMsgVo eventMsgVo;

    private static GlobalPluginHandel getGlobalPluginHandel() {
        if (globalPluginHandel == null) {
            globalPluginHandel = GlobalPluginHandel.getInstance();
        }
        return globalPluginHandel;
    }

    public GlobalEventHandle(EventMsgVo eventMsgVo) {
        this.eventMsgVo = eventMsgVo;
    }

    @Override
    public void run() {
        String eventType = this.eventMsgVo.getHeader().getEventType();
        if (EventType.MESSAGE_RECEIVE_NORMAL.getCode().equals(eventType)) {
            GlobalEventHandle.eventMessageReceiveNormal(this.eventMsgVo);
        } else if (EventType.MESSAGE_RECEIVE_INSTRUCTION.getCode().equals(eventType)) {
            GlobalEventHandle.eventMessageReceiveInstruction(this.eventMsgVo);
        } else if (EventType.BOT_FOLLOWED.getCode().equals(eventType)) {
            GlobalEventHandle.eventBotFollwed(this.eventMsgVo);
        } else if (EventType.BOT_UNFOLLOWED.getCode().equals(eventType)) {
            GlobalEventHandle.eventBotUnfollwed(this.eventMsgVo);
        } else if (EventType.BUTTON_REPORT_INLINE.getCode().equals(eventType)) {
            GlobalEventHandle.eventButtonReportInline(this.eventMsgVo);
        } else if (EventType.GROUP_JOIN.getCode().equals(eventType)) {
            GlobalEventHandle.eventGroupJoin(this.eventMsgVo);
        } else if (EventType.GROUP_LEAVE.getCode().equals(eventType)) {
            GlobalEventHandle.eventGroupLeave(this.eventMsgVo);
        } else if (EventType.BOT_SETTING.getCode().equals(eventType)) {
            GlobalEventHandle.eventBotSetting(this.eventMsgVo);
        } else {
            log.error("\u3010core\u3011\u4e8b\u4ef6\u6295\u9012\u5931\u8d25\uff0c\u672a\u77e5\u7684\u6d88\u606f\u7c7b\u578b\uff1a{}", (Object)eventType);
        }
    }

    public static void eventMessageReceiveNormal(EventMsgVo eventMsgVo) {
        List<PluginManagerVo.EventMessageReceiveNormalVo> list = GlobalEventHandle.getGlobalPluginHandel().getEventMessageReceiveNormalVos();
        for (PluginManagerVo.EventMessageReceiveNormalVo vo : list) {
            try {
                Integer integer = vo.getBean().handle(eventMsgVo);
                if (integer != -1) continue;
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error("\u3010core\u3011\u63d2\u4ef6[{}]\u53d1\u9001\u5f02\u5e38\uff1a{}", (Object)vo.getPluginName(), (Object)e.getMessage());
            }
        }
    }

    public static void eventMessageReceiveInstruction(EventMsgVo eventMsgVo) {
        List<PluginManagerVo.EventMessageReceiveInstructionVo> list = GlobalEventHandle.getGlobalPluginHandel().getEventMessageReceiveInstructionVos();
        for (PluginManagerVo.EventMessageReceiveInstructionVo vo : list) {
            try {
                Integer integer = vo.getBean().handle(eventMsgVo);
                if (integer != -1) continue;
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error("\u3010core\u3011\u63d2\u4ef6[{}]\u53d1\u9001\u5f02\u5e38\uff1a{}", (Object)vo.getPluginName(), (Object)e.getMessage());
            }
        }
    }

    public static void eventBotFollwed(EventMsgVo eventMsgVo) {
        List<PluginManagerVo.EventBotFollwedVo> list = GlobalEventHandle.getGlobalPluginHandel().getEventBotFollwedVos();
        for (PluginManagerVo.EventBotFollwedVo vo : list) {
            try {
                Integer integer = vo.getBean().handle(eventMsgVo);
                if (integer != -1) continue;
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error("\u3010core\u3011\u63d2\u4ef6[{}]\u53d1\u9001\u5f02\u5e38\uff1a{}", (Object)vo.getPluginName(), (Object)e.getMessage());
            }
        }
    }

    public static void eventBotUnfollwed(EventMsgVo eventMsgVo) {
        List<PluginManagerVo.EventBotUnfollwedVo> list = GlobalEventHandle.getGlobalPluginHandel().getEventBotUnfollwedVos();
        for (PluginManagerVo.EventBotUnfollwedVo vo : list) {
            try {
                Integer integer = vo.getBean().handle(eventMsgVo);
                if (integer != -1) continue;
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error("\u3010core\u3011\u63d2\u4ef6[{}]\u53d1\u9001\u5f02\u5e38\uff1a{}", (Object)vo.getPluginName(), (Object)e.getMessage());
            }
        }
    }

    public static void eventButtonReportInline(EventMsgVo eventMsgVo) {
        List<PluginManagerVo.EventButtonReportInlineVo> list = GlobalEventHandle.getGlobalPluginHandel().getEventButtonReportInlineVos();
        for (PluginManagerVo.EventButtonReportInlineVo vo : list) {
            try {
                Integer integer = vo.getBean().handle(eventMsgVo);
                if (integer != -1) continue;
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error("\u3010core\u3011\u63d2\u4ef6[{}]\u53d1\u9001\u5f02\u5e38\uff1a{}", (Object)vo.getPluginName(), (Object)e.getMessage());
            }
        }
    }

    public static void eventGroupJoin(EventMsgVo eventMsgVo) {
        List<PluginManagerVo.EventGroupJoinVo> list = GlobalEventHandle.getGlobalPluginHandel().getEventGroupJoinVos();
        for (PluginManagerVo.EventGroupJoinVo vo : list) {
            try {
                Integer integer = vo.getBean().handle(eventMsgVo);
                if (integer != -1) continue;
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error("\u3010core\u3011\u63d2\u4ef6[{}]\u53d1\u9001\u5f02\u5e38\uff1a{}", (Object)vo.getPluginName(), (Object)e.getMessage());
            }
        }
    }

    public static void eventGroupLeave(EventMsgVo eventMsgVo) {
        List<PluginManagerVo.EventGroupLeaveVo> list = GlobalEventHandle.getGlobalPluginHandel().getEventGroupLeaveVos();
        for (PluginManagerVo.EventGroupLeaveVo vo : list) {
            try {
                Integer integer = vo.getBean().handle(eventMsgVo);
                if (integer != -1) continue;
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error("\u3010core\u3011\u63d2\u4ef6[{}]\u53d1\u9001\u5f02\u5e38\uff1a{}", (Object)vo.getPluginName(), (Object)e.getMessage());
            }
        }
    }

    public static void eventBotSetting(EventMsgVo eventMsgVo) {
        List<PluginManagerVo.EventBotSettingVo> list = GlobalEventHandle.getGlobalPluginHandel().getEventBotSettingVos();
        for (PluginManagerVo.EventBotSettingVo vo : list) {
            try {
                Integer integer = vo.getBean().handle(eventMsgVo);
                if (integer != -1) continue;
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error("\u3010core\u3011\u63d2\u4ef6[{}]\u53d1\u9001\u5f02\u5e38\uff1a{}", (Object)vo.getPluginName(), (Object)e.getMessage());
            }
        }
    }
}

