/*
 * Decompiled with CFR 0.152.
 */
package cn.cyejing.ngrok.core.woker;

import cn.cyejing.ngrok.core.MessageHandler;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import java.io.BufferedInputStream;
import java.nio.ByteBuffer;
import javax.net.ssl.SSLSocket;
import org.apache.commons.lang.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageListenerWorker
implements Runnable {
    Logger log = LoggerFactory.getLogger(MessageListenerWorker.class);
    private final SSLSocket socket;
    private final MessageHandler messageHandler;

    public MessageListenerWorker(MessageHandler messageHandler) {
        this.messageHandler = messageHandler;
        this.socket = messageHandler.getSocket();
    }

    @Override
    public void run() {
        try {
            this.log.debug("Waiting to read message");
            byte[] hLen = new byte[8];
            BufferedInputStream bis = new BufferedInputStream(this.socket.getInputStream());
            while (true) {
                int read;
                if (bis.available() >= 8) {
                    continue;
                }
                int i = bis.read(hLen);
                if (i == -1) {
                    return;
                }
                ArrayUtils.reverse((byte[])hLen);
                int strLen = Long.valueOf(ByteBuffer.wrap(hLen).getLong()).intValue();
                this.log.debug("Reading message with length: {}", (Object)strLen);
                byte[] strByte = new byte[strLen];
                for (int readCount = 0; readCount < strLen; readCount += read) {
                    read = bis.read(strByte, readCount, strLen - readCount);
                    if (read != -1) continue;
                    return;
                }
                JSONObject json = (JSONObject)JSON.parseObject((byte[])strByte, JSONObject.class, (Feature[])new Feature[0]);
                this.log.debug("Read message: {}", (Object)json.toJSONString());
                if (this.messageHandler.onMessage(json)) break;
            }
        }
        catch (Exception e) {
            this.log.error("Occurred some exception", (Throwable)e);
        }
    }
}

