/*
 * Decompiled with CFR 0.152.
 */
package cn.cyejing.ngrok.core;

import org.apache.commons.lang.StringUtils;

public class Tunnel {
    private int port;
    private String proto;
    private String subDomain;
    private String hostname;
    private int remotePort;
    private String httpAuth;

    private Tunnel() {
    }

    private Tunnel(int port, String proto, String subDomain, String hostname, int remotePort, String httpAuth) {
        this.port = port;
        this.proto = proto;
        this.subDomain = subDomain;
        this.hostname = hostname;
        this.remotePort = remotePort;
        this.httpAuth = httpAuth;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getProto() {
        return this.proto;
    }

    public void setProto(String proto) {
        this.proto = proto;
    }

    public String getSubDomain() {
        return this.subDomain;
    }

    public void setSubDomain(String subDomain) {
        this.subDomain = subDomain;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public int getRemotePort() {
        return this.remotePort;
    }

    public void setRemotePort(int remotePort) {
        this.remotePort = remotePort;
    }

    public String getHttpAuth() {
        return this.httpAuth;
    }

    public void setHttpAuth(String httpAuth) {
        this.httpAuth = httpAuth;
    }

    public static class TunnelBuild {
        private int port;
        private String proto;
        private String subDomain;
        private String hostname;
        private int remotePort;
        private String httpAuth;

        public Tunnel build() {
            if (this.port == 0) {
                throw new IllegalArgumentException("port can not be zone");
            }
            if (StringUtils.isBlank((String)this.proto)) {
                throw new IllegalArgumentException("Proto can not be empty");
            }
            return new Tunnel(this.port, this.proto, this.subDomain, this.hostname, this.remotePort, this.httpAuth);
        }

        public TunnelBuild setPort(int port) {
            this.port = port;
            return this;
        }

        public TunnelBuild setHostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public TunnelBuild setHttpAuth(String httpAuth) {
            this.httpAuth = httpAuth;
            return this;
        }

        public TunnelBuild setProto(String proto) {
            this.proto = proto;
            return this;
        }

        public TunnelBuild setRemotePort(int remotePort) {
            this.remotePort = remotePort;
            return this;
        }

        public TunnelBuild setSubDomain(String subDomain) {
            this.subDomain = subDomain;
            return this;
        }
    }
}

