/*
 * Decompiled with CFR 0.152.
 */
package cn.cyejing.ngrok.core;

import cn.cyejing.ngrok.core.SocketFactory;
import cn.cyejing.ngrok.core.Tunnel;
import cn.cyejing.ngrok.core.WorkerPool;
import cn.cyejing.ngrok.core.woker.HealthCheckWorker;
import cn.cyejing.ngrok.core.woker.MessageListenerWorker;
import cn.cyejing.ngrok.core.woker.SocketSwapWorker;
import com.alibaba.fastjson.JSONObject;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.net.ssl.SSLSocket;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageHandler {
    Logger log = LoggerFactory.getLogger(MessageHandler.class);
    private SSLSocket socket;
    private SocketFactory socketFactory;
    private String clientId;
    private List<Tunnel> tunnels;
    private Map<String, Tunnel> mappingMap = new HashMap<String, Tunnel>();

    public MessageHandler(SSLSocket socket, SocketFactory socketFactory, List<Tunnel> tunnels) {
        this.socket = socket;
        this.socketFactory = socketFactory;
        this.tunnels = tunnels;
    }

    public boolean onMessage(JSONObject json) throws Exception {
        String type = json.getString("Type");
        JSONObject payload = json.getJSONObject("Payload");
        switch (type) {
            case "AuthResp": {
                String clientId;
                this.clientId = clientId = payload.getString("ClientId");
                String error = payload.getString("Error");
                if (StringUtils.isBlank((String)error)) {
                    this.log.debug("auth succeed...");
                    this.sendReqTunnel();
                    WorkerPool.submit(new HealthCheckWorker(this));
                    break;
                }
                WorkerPool.shutdown();
                this.log.error("auth failed error: {}", (Object)error);
                break;
            }
            case "NewTunnel": {
                String error = payload.getString("Error");
                String reqId = payload.getString("ReqId");
                String url = payload.getString("Url");
                if (StringUtils.isBlank((String)error)) {
                    this.mappingMap.put(url, this.mappingMap.get(reqId));
                    this.log.info("register url: {}", (Object)url);
                    break;
                }
                WorkerPool.shutdown();
                this.log.error("NewTunnel failed error: {}", (Object)error);
                break;
            }
            case "ReqProxy": {
                MessageHandler messageHandler = this.newSocketAndCopy();
                messageHandler.sendRegProxy();
                WorkerPool.submit(new MessageListenerWorker(messageHandler));
                break;
            }
            case "StartProxy": {
                String url = payload.getString("Url");
                Tunnel tunnel = this.mappingMap.get(url);
                Socket locals = new Socket("127.0.0.1", tunnel.getPort());
                WorkerPool.submit(new SocketSwapWorker(this.socket.getInputStream(), locals.getOutputStream()));
                WorkerPool.submit(new SocketSwapWorker(locals.getInputStream(), this.socket.getOutputStream()));
                return true;
            }
        }
        return false;
    }

    private MessageHandler newSocketAndCopy() {
        SSLSocket newSocket = this.socketFactory.build();
        MessageHandler messageHandler = new MessageHandler(newSocket, this.socketFactory, null);
        messageHandler.setClientId(this.clientId);
        messageHandler.setMappingMap(this.mappingMap);
        return messageHandler;
    }

    public void sendAuth() {
        JSONObject request = new JSONObject();
        request.put("Type", (Object)"Auth");
        JSONObject payload = new JSONObject();
        payload.put("Version", (Object)"2");
        payload.put("MmVersion", (Object)"1.7");
        payload.put("User", (Object)"");
        payload.put("Password", (Object)"");
        payload.put("OS", (Object)"darwin");
        payload.put("Arch", (Object)"amd64");
        payload.put("ClientId", (Object)"");
        request.put("Payload", (Object)payload);
        this.sendMessage(request.toJSONString());
    }

    public void sendReqTunnel() {
        for (Tunnel tunnel : this.tunnels) {
            JSONObject reuqest = new JSONObject();
            reuqest.put("Type", (Object)"ReqTunnel");
            JSONObject payload = new JSONObject();
            String reqId = UUID.randomUUID().toString().toLowerCase().replace("-", "").substring(0, 16);
            this.mappingMap.put(reqId, tunnel);
            payload.put("ReqId", (Object)reqId);
            payload.put("Protocol", (Object)tunnel.getProto());
            if (tunnel.getProto().equals("tcp")) {
                payload.put("RemotePort", (Object)tunnel.getRemotePort());
            } else {
                payload.put("Subdomain", (Object)tunnel.getSubDomain());
                payload.put("HttpAuth", (Object)tunnel.getHttpAuth());
                payload.put("Hostname", (Object)tunnel.getHostname());
            }
            reuqest.put("Payload", (Object)payload);
            this.sendMessage(reuqest.toJSONString());
        }
    }

    public void sendPong() {
        this.sendMessage("{\"Type\":\"Pong\",\"Payload\":{}}");
    }

    public void sendPing() {
        this.sendMessage("{\"Type\":\"Ping\",\"Payload\":{}}");
    }

    public void sendRegProxy() {
        this.sendMessage("{\"Type\":\"RegProxy\",\"Payload\":{\"ClientId\":\"" + this.clientId + "\"}}");
    }

    public void sendMessage(String str) {
        this.log.debug("Writing message: {}", (Object)str);
        try {
            BufferedOutputStream bos = new BufferedOutputStream(this.socket.getOutputStream());
            byte[] len = ByteBuffer.allocate(8).putLong(str.length()).array();
            ArrayUtils.reverse((byte[])len);
            ByteBuffer wrap = ByteBuffer.allocate(str.length() + 8);
            byte[] array = wrap.put(len).put(str.getBytes()).array();
            bos.write(array);
            bos.flush();
        }
        catch (IOException e) {
            this.log.error("occurred some exception", (Throwable)e);
        }
    }

    public SSLSocket getSocket() {
        return this.socket;
    }

    public void setSocket(SSLSocket socket) {
        this.socket = socket;
    }

    public SocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    public void setSocketFactory(SocketFactory socketFactory) {
        this.socketFactory = socketFactory;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public List<Tunnel> getTunnels() {
        return this.tunnels;
    }

    public void setTunnels(List<Tunnel> tunnels) {
        this.tunnels = tunnels;
    }

    public Map<String, Tunnel> getMappingMap() {
        return this.mappingMap;
    }

    public void setMappingMap(Map<String, Tunnel> mappingMap) {
        this.mappingMap = mappingMap;
    }
}

