/*
 * Decompiled with CFR 0.152.
 */
package cn.ctyun.sdk;

import cn.ctyun.sdk.Endpoint;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class EndpointRegistry {
    private String defaultUrl;
    private Map<String, String> mapping;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    private EndpointRegistry() {
    }

    public static EndpointRegistry defaultEndpointRegistry(String defaultUrl) {
        EndpointRegistry endpointRegistry = new EndpointRegistry();
        endpointRegistry.mapping = new HashMap<String, String>(0);
        endpointRegistry.defaultUrl = defaultUrl;
        return endpointRegistry;
    }

    public static EndpointRegistry defaultEndpointRegistry() {
        return EndpointRegistry.defaultEndpointRegistry(null);
    }

    public String getEndpointUrl(String endpointName) {
        ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        readLock.lock();
        String result = this.mapping.getOrDefault(endpointName, this.defaultUrl);
        readLock.unlock();
        return result;
    }

    public void register(Endpoint endpoint) {
        ReentrantReadWriteLock.WriteLock writeLock = this.lock.writeLock();
        writeLock.lock();
        if (this.mapping.containsKey(endpoint.name)) {
            throw new IllegalArgumentException("endpoint name: [" + endpoint.name + "] already registered!");
        }
        this.mapping.put(endpoint.name, endpoint.url);
        writeLock.unlock();
    }
}

