/*
 * Decompiled with CFR 0.152.
 */
package cn.ctyun.sdk;

import cn.ctyun.sdk.Credential;
import cn.ctyun.sdk.CtyunRequestException;
import cn.ctyun.sdk.JacksonUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.codec.digest.HmacUtils;

public class CtyunRequest {
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyyMMdd'T'HHmmss'Z'");
    private final String endpointName;
    private final Credential credential;
    private final String method;
    private final String urlPath;
    private CtyunRequestBody body;
    private final Map<String, List<String>> headers = new HashMap<String, List<String>>(0);
    private final Map<String, List<String>> params = new HashMap<String, List<String>>(0);

    protected CtyunRequest(String method, String urlPath, Credential credential, String endpointName) {
        this.method = method;
        this.urlPath = urlPath;
        this.credential = credential;
        this.endpointName = endpointName;
    }

    public CtyunRequest addHeader(String key, String value) {
        this.headers.computeIfAbsent(key, k -> new ArrayList()).add(value);
        return this;
    }

    public CtyunRequest addHeaders(String key, String ... values) {
        for (String value : values) {
            this.addHeader(key, value);
        }
        return this;
    }

    public CtyunRequest addParam(String key, String value) {
        this.params.computeIfAbsent(key, k -> new ArrayList()).add(value);
        return this;
    }

    public CtyunRequest addParams(String key, String ... values) {
        for (String value : values) {
            this.addParam(key, value);
        }
        return this;
    }

    public CtyunRequest writePostNoBody(String contentType) throws CtyunRequestException {
        try {
            this.body = new CtyunRequestBody(contentType, new byte[0]);
        }
        catch (Exception e) {
            throw new CtyunRequestException("write json error", e);
        }
        return this;
    }

    public CtyunRequest writeJson(Object data, String contentType) throws CtyunRequestException {
        try {
            this.body = new CtyunRequestBody(contentType, JacksonUtils.getObjectMapperInstance().writeValueAsBytes(data));
        }
        catch (JsonProcessingException e) {
            throw new CtyunRequestException("write json error", e);
        }
        return this;
    }

    public CtyunRequest writeString(String data, String contentType) throws CtyunRequestException {
        try {
            this.body = new CtyunRequestBody(contentType, data.getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            throw new CtyunRequestException("write String error", e);
        }
        return this;
    }

    public Request buildRequest(String host) {
        HttpUrl httpUrl = this.buildHttpUrl(host);
        Headers headers = this.buildRequestHeader(httpUrl.encodedQuery());
        RequestBody requestBody = this.buildRequestBody();
        return new Request.Builder().method(this.method, requestBody).url(httpUrl).headers(headers).build();
    }

    private HttpUrl buildHttpUrl(String host) {
        HttpUrl baseHttpUrl = HttpUrl.parse(host + this.urlPath);
        if (baseHttpUrl == null) {
            throw new IllegalArgumentException("url: [" + host + this.urlPath + "] error");
        }
        HttpUrl.Builder httpUrlBuilder = baseHttpUrl.newBuilder();
        this.params.forEach((key, values) -> values.forEach(value -> httpUrlBuilder.addQueryParameter((String)key, (String)value)));
        return httpUrlBuilder.build();
    }

    private Headers buildRequestHeader(String query) {
        Headers.Builder headerBuilder = new Headers.Builder();
        this.headers.forEach((key, values) -> values.forEach(value -> headerBuilder.add((String)key, (String)value)));
        String eopDate = DATE_TIME_FORMATTER.format(ZonedDateTime.ofInstant(Instant.now(), ZoneId.of("Asia/Shanghai")));
        String id = UUID.randomUUID().toString();
        byte[] body = Optional.ofNullable(this.body).map(x -> ((CtyunRequestBody)x).content).orElseGet(() -> new byte[0]);
        query = this.handleQueryForSign(query);
        String sign = CtyunRequest.getSign(query, body, eopDate, id, this.credential);
        headerBuilder.add("User-Agent", "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/83.0.4103.116 Safari/537.36");
        headerBuilder.add("ctyun-eop-request-id", id);
        headerBuilder.add("Eop-Authorization", sign);
        headerBuilder.add("Eop-date", eopDate);
        return headerBuilder.build();
    }

    private String handleQueryForSign(String query) {
        if (query == null || query.isEmpty()) {
            return "";
        }
        Object[] params = query.split("&");
        Arrays.sort(params);
        return String.join((CharSequence)"&", (CharSequence[])params);
    }

    private RequestBody buildRequestBody() {
        if (this.body == null || this.body.content == null || this.body.content.length == 0) {
            if (this.method.toLowerCase().equals("post")) {
                return RequestBody.create(MediaType.get(this.body.mediaType), new byte[0]);
            }
            return null;
        }
        return RequestBody.create(MediaType.get(this.body.mediaType), this.body.content);
    }

    private static String getSign(String query, byte[] body, String date, String id, Credential credential) {
        String calculateContentHash = DigestUtils.sha256Hex(body);
        String signature = String.format("ctyun-eop-request-id:%s\neop-date:%s\n\n%s\n%s", id, date, query, calculateContentHash);
        String singerDate = date.substring(0, 8);
        byte[] s = HmacUtils.hmacSha256(credential.sk, date);
        byte[] kAk = HmacUtils.hmacSha256(s, credential.ak.getBytes(StandardCharsets.UTF_8));
        byte[] kDate = HmacUtils.hmacSha256(kAk, singerDate.getBytes(StandardCharsets.UTF_8));
        byte[] signatureSha256 = HmacUtils.hmacSha256(kDate, signature.getBytes(StandardCharsets.UTF_8));
        String signatureBase64 = Base64.getEncoder().encodeToString(signatureSha256);
        return credential.ak + " Headers=ctyun-eop-request-id;eop-date Signature=" + signatureBase64;
    }

    public String getEndpointName() {
        return this.endpointName;
    }

    private static class CtyunRequestBody {
        private final String mediaType;
        private final byte[] content;

        private CtyunRequestBody(String mediaType, byte[] content) {
            this.mediaType = mediaType;
            this.content = content;
        }
    }
}

