/*
 * Decompiled with CFR 0.152.
 */
package cn.ctyun.apis;

import cn.ctyun.sdk.Credential;
import cn.ctyun.sdk.CtyunClient;
import cn.ctyun.sdk.CtyunRequest;
import cn.ctyun.sdk.CtyunRequestBuilder;
import cn.ctyun.sdk.CtyunRequestException;
import cn.ctyun.sdk.CtyunRequestTemplate;
import cn.ctyun.sdk.CtyunResponse;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public class CtvpcVpcCreateSubnetApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CtvpcVpcCreateSubnetApi(CtyunClient client) {
        this.client = client;
        this.template = new CtyunRequestTemplate("ctvpc", "POST", "/v4/vpc/create-subnet", "application/json");
    }

    public VpcCreateSubnetResponse send(Credential credential, VpcCreateSubnetRequest request) throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(this.template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        ctReq.writeJson(request, this.template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(VpcCreateSubnetResponse.class);
    }

    public static class VpcCreateSubnetReturnObjResponse {
        @JsonProperty(value="subnetID")
        private String subnetID;

        public String getSubnetID() {
            return this.subnetID;
        }

        public void setSubnetID(String subnetID) {
            this.subnetID = subnetID;
        }
    }

    public static class VpcCreateSubnetResponse {
        @JsonProperty(value="statusCode")
        private Integer statusCode;
        @JsonProperty(value="message")
        private String message;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="errorCode")
        private String errorCode;
        @JsonProperty(value="returnObj")
        private VpcCreateSubnetReturnObjResponse returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public VpcCreateSubnetReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(VpcCreateSubnetReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class VpcCreateSubnetRequest {
        @JsonProperty(value="clientToken")
        private String clientToken;
        @JsonProperty(value="regionID")
        private String regionID;
        @JsonProperty(value="vpcID")
        private String vpcID;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="CIDR")
        private String cIDR;
        @JsonProperty(value="enableIpv6")
        private Boolean enableIpv6;
        @JsonProperty(value="dnsList")
        private List<String> dnsList;
        @JsonProperty(value="subnetGatewayIP")
        private String subnetGatewayIP;
        @JsonProperty(value="subnetType")
        private String subnetType;
        @JsonProperty(value="dhcpIP")
        private String dhcpIP;

        public String getClientToken() {
            return this.clientToken;
        }

        public void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }

        public String getVpcID() {
            return this.vpcID;
        }

        public void setVpcID(String vpcID) {
            this.vpcID = vpcID;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getCIDR() {
            return this.cIDR;
        }

        public void setCIDR(String cIDR) {
            this.cIDR = cIDR;
        }

        public Boolean getEnableIpv6() {
            return this.enableIpv6;
        }

        public void setEnableIpv6(Boolean enableIpv6) {
            this.enableIpv6 = enableIpv6;
        }

        public List<String> getDnsList() {
            return this.dnsList;
        }

        public void setDnsList(List<String> dnsList) {
            this.dnsList = dnsList;
        }

        public String getSubnetGatewayIP() {
            return this.subnetGatewayIP;
        }

        public void setSubnetGatewayIP(String subnetGatewayIP) {
            this.subnetGatewayIP = subnetGatewayIP;
        }

        public String getSubnetType() {
            return this.subnetType;
        }

        public void setSubnetType(String subnetType) {
            this.subnetType = subnetType;
        }

        public String getDhcpIP() {
            return this.dhcpIP;
        }

        public void setDhcpIP(String dhcpIP) {
            this.dhcpIP = dhcpIP;
        }
    }
}

