/*
 * Decompiled with CFR 0.152.
 */
package cn.ctyun.apis;

import cn.ctyun.sdk.Credential;
import cn.ctyun.sdk.CtyunClient;
import cn.ctyun.sdk.CtyunRequest;
import cn.ctyun.sdk.CtyunRequestBuilder;
import cn.ctyun.sdk.CtyunRequestException;
import cn.ctyun.sdk.CtyunRequestTemplate;
import cn.ctyun.sdk.CtyunResponse;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public class CtvpcUpdatePortApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CtvpcUpdatePortApi(CtyunClient client) {
        this.client = client;
        this.template = new CtyunRequestTemplate("ctvpc", "POST", "/v4/ports/update", "application/json");
    }

    public UpdatePortResponse send(Credential credential, UpdatePortRequest request) throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(this.template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        ctReq.writeJson(request, this.template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(UpdatePortResponse.class);
    }

    public static class UpdatePortReturnObjResponse {
        @JsonProperty(value="portID")
        private String portID;
        @JsonProperty(value="createdAt")
        private String createdAt;
        @JsonProperty(value="updatedAt")
        private String updatedAt;

        public String getPortID() {
            return this.portID;
        }

        public void setPortID(String portID) {
            this.portID = portID;
        }

        public String getCreatedAt() {
            return this.createdAt;
        }

        public void setCreatedAt(String createdAt) {
            this.createdAt = createdAt;
        }

        public String getUpdatedAt() {
            return this.updatedAt;
        }

        public void setUpdatedAt(String updatedAt) {
            this.updatedAt = updatedAt;
        }
    }

    public static class UpdatePortResponse {
        @JsonProperty(value="statusCode")
        private Integer statusCode;
        @JsonProperty(value="message")
        private String message;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="errorCode")
        private String errorCode;
        @JsonProperty(value="returnObj")
        private UpdatePortReturnObjResponse returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public UpdatePortReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(UpdatePortReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class UpdatePortRequest {
        @JsonProperty(value="clientToken")
        private String clientToken;
        @JsonProperty(value="regionID")
        private String regionID;
        @JsonProperty(value="networkInterfaceID")
        private String networkInterfaceID;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="securityGroupIDs")
        private List<String> securityGroupIDs;

        public String getClientToken() {
            return this.clientToken;
        }

        public void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }

        public String getNetworkInterfaceID() {
            return this.networkInterfaceID;
        }

        public void setNetworkInterfaceID(String networkInterfaceID) {
            this.networkInterfaceID = networkInterfaceID;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public List<String> getSecurityGroupIDs() {
            return this.securityGroupIDs;
        }

        public void setSecurityGroupIDs(List<String> securityGroupIDs) {
            this.securityGroupIDs = securityGroupIDs;
        }
    }
}

