/*
 * Decompiled with CFR 0.152.
 */
package cn.ctyun.apis;

import cn.ctyun.sdk.Credential;
import cn.ctyun.sdk.CtyunClient;
import cn.ctyun.sdk.CtyunRequest;
import cn.ctyun.sdk.CtyunRequestBuilder;
import cn.ctyun.sdk.CtyunRequestException;
import cn.ctyun.sdk.CtyunRequestTemplate;
import cn.ctyun.sdk.CtyunResponse;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public class CtvpcShowRouteTableApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CtvpcShowRouteTableApi(CtyunClient client) {
        this.client = client;
        this.template = new CtyunRequestTemplate("ctvpc", "GET", "/v4/vpc/route-table/show", "application/json");
    }

    public ShowRouteTableResponse send(Credential credential, ShowRouteTableRequest request) throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(this.template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionID != null) {
            ctReq.addParam("regionID", request.regionID);
            request.regionID = null;
        }
        if (request.routeTableID != null) {
            ctReq.addParam("routeTableID", request.routeTableID);
            request.routeTableID = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(ShowRouteTableResponse.class);
    }

    public static class ShowRouteTableReturnObjSubnetDetailResponse {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="cidr")
        private String cidr;
        @JsonProperty(value="ipv6Cidr")
        private String ipv6Cidr;

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getCidr() {
            return this.cidr;
        }

        public void setCidr(String cidr) {
            this.cidr = cidr;
        }

        public String getIpv6Cidr() {
            return this.ipv6Cidr;
        }

        public void setIpv6Cidr(String ipv6Cidr) {
            this.ipv6Cidr = ipv6Cidr;
        }
    }

    public static class ShowRouteTableReturnObjResponse {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="vpcID")
        private String vpcID;
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="freezing")
        private Boolean freezing;
        @JsonProperty(value="routeRulesCount")
        private Integer routeRulesCount;
        @JsonProperty(value="createdAt")
        private String createdAt;
        @JsonProperty(value="updatedAt")
        private String updatedAt;
        @JsonProperty(value="routeRules")
        private List<String> routeRules;
        @JsonProperty(value="subnetDetail")
        private List<ShowRouteTableReturnObjSubnetDetailResponse> subnetDetail;
        @JsonProperty(value="type")
        private Integer type;
        @JsonProperty(value="origin")
        private String origin;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getVpcID() {
            return this.vpcID;
        }

        public void setVpcID(String vpcID) {
            this.vpcID = vpcID;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public Boolean getFreezing() {
            return this.freezing;
        }

        public void setFreezing(Boolean freezing) {
            this.freezing = freezing;
        }

        public Integer getRouteRulesCount() {
            return this.routeRulesCount;
        }

        public void setRouteRulesCount(Integer routeRulesCount) {
            this.routeRulesCount = routeRulesCount;
        }

        public String getCreatedAt() {
            return this.createdAt;
        }

        public void setCreatedAt(String createdAt) {
            this.createdAt = createdAt;
        }

        public String getUpdatedAt() {
            return this.updatedAt;
        }

        public void setUpdatedAt(String updatedAt) {
            this.updatedAt = updatedAt;
        }

        public List<String> getRouteRules() {
            return this.routeRules;
        }

        public void setRouteRules(List<String> routeRules) {
            this.routeRules = routeRules;
        }

        public List<ShowRouteTableReturnObjSubnetDetailResponse> getSubnetDetail() {
            return this.subnetDetail;
        }

        public void setSubnetDetail(List<ShowRouteTableReturnObjSubnetDetailResponse> subnetDetail) {
            this.subnetDetail = subnetDetail;
        }

        public Integer getType() {
            return this.type;
        }

        public void setType(Integer type) {
            this.type = type;
        }

        public String getOrigin() {
            return this.origin;
        }

        public void setOrigin(String origin) {
            this.origin = origin;
        }
    }

    public static class ShowRouteTableResponse {
        @JsonProperty(value="statusCode")
        private Integer statusCode;
        @JsonProperty(value="message")
        private String message;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="errorCode")
        private String errorCode;
        @JsonProperty(value="returnObj")
        private ShowRouteTableReturnObjResponse returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public ShowRouteTableReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(ShowRouteTableReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class ShowRouteTableRequest {
        @JsonProperty(value="regionID")
        private String regionID;
        @JsonProperty(value="routeTableID")
        private String routeTableID;

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }

        public String getRouteTableID() {
            return this.routeTableID;
        }

        public void setRouteTableID(String routeTableID) {
            this.routeTableID = routeTableID;
        }
    }
}

