/*
 * Decompiled with CFR 0.152.
 */
package cn.ctyun.apis;

import cn.ctyun.sdk.Credential;
import cn.ctyun.sdk.CtyunClient;
import cn.ctyun.sdk.CtyunRequest;
import cn.ctyun.sdk.CtyunRequestBuilder;
import cn.ctyun.sdk.CtyunRequestException;
import cn.ctyun.sdk.CtyunRequestTemplate;
import cn.ctyun.sdk.CtyunResponse;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public class CtvpcShowPortApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CtvpcShowPortApi(CtyunClient client) {
        this.client = client;
        this.template = new CtyunRequestTemplate("ctvpc", "GET", "/v4/ports/show", "application/json");
    }

    public ShowPortResponse send(Credential credential, ShowPortRequest request) throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(this.template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionID != null) {
            ctReq.addParam("regionID", request.regionID);
            request.regionID = null;
        }
        if (request.networkInterfaceID != null) {
            ctReq.addParam("networkInterfaceID", request.networkInterfaceID);
            request.networkInterfaceID = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(ShowPortResponse.class);
    }

    public static class ShowPortReturnObjAssociatedEipResponse {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="name")
        private String name;

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    public static class ShowPortReturnObjResponse {
        @JsonProperty(value="networkInterfaceName")
        private String networkInterfaceName;
        @JsonProperty(value="networkInterfaceID")
        private String networkInterfaceID;
        @JsonProperty(value="vpcID")
        private String vpcID;
        @JsonProperty(value="subnetID")
        private String subnetID;
        @JsonProperty(value="role")
        private Integer role;
        @JsonProperty(value="macAddress")
        private String macAddress;
        @JsonProperty(value="primaryPrivateIp")
        private String primaryPrivateIp;
        @JsonProperty(value="ipv6Addresses")
        private List<String> ipv6Addresses;
        @JsonProperty(value="instanceID")
        private String instanceID;
        @JsonProperty(value="instanceType")
        private String instanceType;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="securityGroupIds")
        private List<String> securityGroupIds;
        @JsonProperty(value="secondaryPrivateIps")
        private List<String> secondaryPrivateIps;
        @JsonProperty(value="adminStatus")
        private String adminStatus;
        @JsonProperty(value="createdAt")
        private String createdAt;
        @JsonProperty(value="updatedAt")
        private String updatedAt;
        @JsonProperty(value="associatedEip")
        private ShowPortReturnObjAssociatedEipResponse associatedEip;

        public String getNetworkInterfaceName() {
            return this.networkInterfaceName;
        }

        public void setNetworkInterfaceName(String networkInterfaceName) {
            this.networkInterfaceName = networkInterfaceName;
        }

        public String getNetworkInterfaceID() {
            return this.networkInterfaceID;
        }

        public void setNetworkInterfaceID(String networkInterfaceID) {
            this.networkInterfaceID = networkInterfaceID;
        }

        public String getVpcID() {
            return this.vpcID;
        }

        public void setVpcID(String vpcID) {
            this.vpcID = vpcID;
        }

        public String getSubnetID() {
            return this.subnetID;
        }

        public void setSubnetID(String subnetID) {
            this.subnetID = subnetID;
        }

        public Integer getRole() {
            return this.role;
        }

        public void setRole(Integer role) {
            this.role = role;
        }

        public String getMacAddress() {
            return this.macAddress;
        }

        public void setMacAddress(String macAddress) {
            this.macAddress = macAddress;
        }

        public String getPrimaryPrivateIp() {
            return this.primaryPrivateIp;
        }

        public void setPrimaryPrivateIp(String primaryPrivateIp) {
            this.primaryPrivateIp = primaryPrivateIp;
        }

        public List<String> getIpv6Addresses() {
            return this.ipv6Addresses;
        }

        public void setIpv6Addresses(List<String> ipv6Addresses) {
            this.ipv6Addresses = ipv6Addresses;
        }

        public String getInstanceID() {
            return this.instanceID;
        }

        public void setInstanceID(String instanceID) {
            this.instanceID = instanceID;
        }

        public String getInstanceType() {
            return this.instanceType;
        }

        public void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public List<String> getSecurityGroupIds() {
            return this.securityGroupIds;
        }

        public void setSecurityGroupIds(List<String> securityGroupIds) {
            this.securityGroupIds = securityGroupIds;
        }

        public List<String> getSecondaryPrivateIps() {
            return this.secondaryPrivateIps;
        }

        public void setSecondaryPrivateIps(List<String> secondaryPrivateIps) {
            this.secondaryPrivateIps = secondaryPrivateIps;
        }

        public String getAdminStatus() {
            return this.adminStatus;
        }

        public void setAdminStatus(String adminStatus) {
            this.adminStatus = adminStatus;
        }

        public String getCreatedAt() {
            return this.createdAt;
        }

        public void setCreatedAt(String createdAt) {
            this.createdAt = createdAt;
        }

        public String getUpdatedAt() {
            return this.updatedAt;
        }

        public void setUpdatedAt(String updatedAt) {
            this.updatedAt = updatedAt;
        }

        public ShowPortReturnObjAssociatedEipResponse getAssociatedEip() {
            return this.associatedEip;
        }

        public void setAssociatedEip(ShowPortReturnObjAssociatedEipResponse associatedEip) {
            this.associatedEip = associatedEip;
        }
    }

    public static class ShowPortResponse {
        @JsonProperty(value="statusCode")
        private Integer statusCode;
        @JsonProperty(value="message")
        private String message;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="errorCode")
        private String errorCode;
        @JsonProperty(value="returnObj")
        private ShowPortReturnObjResponse returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public ShowPortReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(ShowPortReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class ShowPortRequest {
        @JsonProperty(value="regionID")
        private String regionID;
        @JsonProperty(value="networkInterfaceID")
        private String networkInterfaceID;

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }

        public String getNetworkInterfaceID() {
            return this.networkInterfaceID;
        }

        public void setNetworkInterfaceID(String networkInterfaceID) {
            this.networkInterfaceID = networkInterfaceID;
        }
    }
}

