/*
 * Decompiled with CFR 0.152.
 */
package cn.ctyun.apis;

import cn.ctyun.sdk.Credential;
import cn.ctyun.sdk.CtyunClient;
import cn.ctyun.sdk.CtyunRequest;
import cn.ctyun.sdk.CtyunRequestBuilder;
import cn.ctyun.sdk.CtyunRequestException;
import cn.ctyun.sdk.CtyunRequestTemplate;
import cn.ctyun.sdk.CtyunResponse;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public class CtvpcShowHavipApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CtvpcShowHavipApi(CtyunClient client) {
        this.client = client;
        this.template = new CtyunRequestTemplate("ctvpc", "GET", "/v4/vpc/havip/show", "application/json");
    }

    public ShowHavipResponse send(Credential credential, ShowHavipRequest request) throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(this.template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionID != null) {
            ctReq.addParam("regionID", request.regionID);
            request.regionID = null;
        }
        if (request.haVipID != null) {
            ctReq.addParam("haVipID", request.haVipID);
            request.haVipID = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(ShowHavipResponse.class);
    }

    public static class ShowHavipReturnObjBindPortsResponse {
        @JsonProperty(value="portID")
        private String portID;
        @JsonProperty(value="role")
        private String role;
        @JsonProperty(value="createdAt")
        private String createdAt;

        public String getPortID() {
            return this.portID;
        }

        public void setPortID(String portID) {
            this.portID = portID;
        }

        public String getRole() {
            return this.role;
        }

        public void setRole(String role) {
            this.role = role;
        }

        public String getCreatedAt() {
            return this.createdAt;
        }

        public void setCreatedAt(String createdAt) {
            this.createdAt = createdAt;
        }
    }

    public static class ShowHavipReturnObjNetworkInfoResponse {
        @JsonProperty(value="eipID")
        private String eipID;

        public String getEipID() {
            return this.eipID;
        }

        public void setEipID(String eipID) {
            this.eipID = eipID;
        }
    }

    public static class ShowHavipReturnObjInstanceInfoResponse {
        @JsonProperty(value="instanceName")
        private String instanceName;
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="privateIp")
        private String privateIp;
        @JsonProperty(value="privateIpv6")
        private String privateIpv6;
        @JsonProperty(value="publicIp")
        private String publicIp;

        public String getInstanceName() {
            return this.instanceName;
        }

        public void setInstanceName(String instanceName) {
            this.instanceName = instanceName;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getPrivateIp() {
            return this.privateIp;
        }

        public void setPrivateIp(String privateIp) {
            this.privateIp = privateIp;
        }

        public String getPrivateIpv6() {
            return this.privateIpv6;
        }

        public void setPrivateIpv6(String privateIpv6) {
            this.privateIpv6 = privateIpv6;
        }

        public String getPublicIp() {
            return this.publicIp;
        }

        public void setPublicIp(String publicIp) {
            this.publicIp = publicIp;
        }
    }

    public static class ShowHavipReturnObjResponse {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="ipv4")
        private String ipv4;
        @JsonProperty(value="ipv6")
        private String ipv6;
        @JsonProperty(value="vpcID")
        private String vpcID;
        @JsonProperty(value="subnetID")
        private String subnetID;
        @JsonProperty(value="instanceInfo")
        private List<ShowHavipReturnObjInstanceInfoResponse> instanceInfo;
        @JsonProperty(value="networkInfo")
        private List<ShowHavipReturnObjNetworkInfoResponse> networkInfo;
        @JsonProperty(value="bindPorts")
        private List<ShowHavipReturnObjBindPortsResponse> bindPorts;

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getIpv4() {
            return this.ipv4;
        }

        public void setIpv4(String ipv4) {
            this.ipv4 = ipv4;
        }

        public String getIpv6() {
            return this.ipv6;
        }

        public void setIpv6(String ipv6) {
            this.ipv6 = ipv6;
        }

        public String getVpcID() {
            return this.vpcID;
        }

        public void setVpcID(String vpcID) {
            this.vpcID = vpcID;
        }

        public String getSubnetID() {
            return this.subnetID;
        }

        public void setSubnetID(String subnetID) {
            this.subnetID = subnetID;
        }

        public List<ShowHavipReturnObjInstanceInfoResponse> getInstanceInfo() {
            return this.instanceInfo;
        }

        public void setInstanceInfo(List<ShowHavipReturnObjInstanceInfoResponse> instanceInfo) {
            this.instanceInfo = instanceInfo;
        }

        public List<ShowHavipReturnObjNetworkInfoResponse> getNetworkInfo() {
            return this.networkInfo;
        }

        public void setNetworkInfo(List<ShowHavipReturnObjNetworkInfoResponse> networkInfo) {
            this.networkInfo = networkInfo;
        }

        public List<ShowHavipReturnObjBindPortsResponse> getBindPorts() {
            return this.bindPorts;
        }

        public void setBindPorts(List<ShowHavipReturnObjBindPortsResponse> bindPorts) {
            this.bindPorts = bindPorts;
        }
    }

    public static class ShowHavipResponse {
        @JsonProperty(value="statusCode")
        private Integer statusCode;
        @JsonProperty(value="message")
        private String message;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="errorCode")
        private String errorCode;
        @JsonProperty(value="returnObj")
        private ShowHavipReturnObjResponse returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public ShowHavipReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(ShowHavipReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class ShowHavipRequest {
        @JsonProperty(value="regionID")
        private String regionID;
        @JsonProperty(value="haVipID")
        private String haVipID;

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }

        public String getHaVipID() {
            return this.haVipID;
        }

        public void setHaVipID(String haVipID) {
            this.haVipID = haVipID;
        }
    }
}

