/*
 * Decompiled with CFR 0.152.
 */
package cn.ctyun.apis;

import cn.ctyun.sdk.Credential;
import cn.ctyun.sdk.CtyunClient;
import cn.ctyun.sdk.CtyunRequest;
import cn.ctyun.sdk.CtyunRequestBuilder;
import cn.ctyun.sdk.CtyunRequestException;
import cn.ctyun.sdk.CtyunRequestTemplate;
import cn.ctyun.sdk.CtyunResponse;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public class CtvpcShowAclApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CtvpcShowAclApi(CtyunClient client) {
        this.client = client;
        this.template = new CtyunRequestTemplate("ctvpc", "GET", "/v4/acl/query", "application/json");
    }

    public ShowAclResponse send(Credential credential, ShowAclRequest request) throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(this.template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionID != null) {
            ctReq.addParam("regionID", request.regionID);
            request.regionID = null;
        }
        if (request.aclID != null) {
            ctReq.addParam("aclID", request.aclID);
            request.aclID = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(ShowAclResponse.class);
    }

    public static class ShowAclReturnObjResponse {
        @JsonProperty(value="aclID")
        private String aclID;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="applyToPublicLb")
        private Boolean applyToPublicLb;
        @JsonProperty(value="vpcID")
        private String vpcID;
        @JsonProperty(value="enabled")
        private String enabled;
        @JsonProperty(value="inPolicyID")
        private List<String> inPolicyID;
        @JsonProperty(value="outPolicyID")
        private List<String> outPolicyID;
        @JsonProperty(value="createdAt")
        private String createdAt;
        @JsonProperty(value="updatedAt")
        private String updatedAt;
        @JsonProperty(value="subnetIDs")
        private List<String> subnetIDs;

        public String getAclID() {
            return this.aclID;
        }

        public void setAclID(String aclID) {
            this.aclID = aclID;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public Boolean getApplyToPublicLb() {
            return this.applyToPublicLb;
        }

        public void setApplyToPublicLb(Boolean applyToPublicLb) {
            this.applyToPublicLb = applyToPublicLb;
        }

        public String getVpcID() {
            return this.vpcID;
        }

        public void setVpcID(String vpcID) {
            this.vpcID = vpcID;
        }

        public String getEnabled() {
            return this.enabled;
        }

        public void setEnabled(String enabled) {
            this.enabled = enabled;
        }

        public List<String> getInPolicyID() {
            return this.inPolicyID;
        }

        public void setInPolicyID(List<String> inPolicyID) {
            this.inPolicyID = inPolicyID;
        }

        public List<String> getOutPolicyID() {
            return this.outPolicyID;
        }

        public void setOutPolicyID(List<String> outPolicyID) {
            this.outPolicyID = outPolicyID;
        }

        public String getCreatedAt() {
            return this.createdAt;
        }

        public void setCreatedAt(String createdAt) {
            this.createdAt = createdAt;
        }

        public String getUpdatedAt() {
            return this.updatedAt;
        }

        public void setUpdatedAt(String updatedAt) {
            this.updatedAt = updatedAt;
        }

        public List<String> getSubnetIDs() {
            return this.subnetIDs;
        }

        public void setSubnetIDs(List<String> subnetIDs) {
            this.subnetIDs = subnetIDs;
        }
    }

    public static class ShowAclResponse {
        @JsonProperty(value="statusCode")
        private Integer statusCode;
        @JsonProperty(value="message")
        private String message;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="errorCode")
        private String errorCode;
        @JsonProperty(value="returnObj")
        private ShowAclReturnObjResponse returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public ShowAclReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(ShowAclReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class ShowAclRequest {
        @JsonProperty(value="regionID")
        private String regionID;
        @JsonProperty(value="aclID")
        private String aclID;

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }

        public String getAclID() {
            return this.aclID;
        }

        public void setAclID(String aclID) {
            this.aclID = aclID;
        }
    }
}

