/*
 * Decompiled with CFR 0.152.
 */
package cn.ctyun.apis;

import cn.ctyun.sdk.Credential;
import cn.ctyun.sdk.CtyunClient;
import cn.ctyun.sdk.CtyunRequest;
import cn.ctyun.sdk.CtyunRequestBuilder;
import cn.ctyun.sdk.CtyunRequestException;
import cn.ctyun.sdk.CtyunRequestTemplate;
import cn.ctyun.sdk.CtyunResponse;
import com.fasterxml.jackson.annotation.JsonProperty;

public class CtvpcSgRulePreCheckApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CtvpcSgRulePreCheckApi(CtyunClient client) {
        this.client = client;
        this.template = new CtyunRequestTemplate("ctvpc", "POST", "/v4/vpc/pre-check-sg-rule", "application/json");
    }

    public SgRulePreCheckResponse send(Credential credential, SgRulePreCheckRequest request) throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(this.template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        ctReq.writeJson(request, this.template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(SgRulePreCheckResponse.class);
    }

    public static class SgRulePreCheckReturnObjResponse {
        @JsonProperty(value="sgRuleID")
        private String sgRuleID;

        public String getSgRuleID() {
            return this.sgRuleID;
        }

        public void setSgRuleID(String sgRuleID) {
            this.sgRuleID = sgRuleID;
        }
    }

    public static class SgRulePreCheckResponse {
        @JsonProperty(value="statusCode")
        private Integer statusCode;
        @JsonProperty(value="message")
        private String message;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="errorCode")
        private String errorCode;
        @JsonProperty(value="returnObj")
        private SgRulePreCheckReturnObjResponse returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public SgRulePreCheckReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(SgRulePreCheckReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class SgRulePreCheckSecurityGroupRuleRequest {
        @JsonProperty(value="direction")
        private String direction;
        @JsonProperty(value="action")
        private String action;
        @JsonProperty(value="priority")
        private Integer priority;
        @JsonProperty(value="protocol")
        private String protocol;
        @JsonProperty(value="ethertype")
        private String ethertype;
        @JsonProperty(value="destCidrIp")
        private String destCidrIp;
        @JsonProperty(value="range")
        private String range;

        public String getDirection() {
            return this.direction;
        }

        public void setDirection(String direction) {
            this.direction = direction;
        }

        public String getAction() {
            return this.action;
        }

        public void setAction(String action) {
            this.action = action;
        }

        public Integer getPriority() {
            return this.priority;
        }

        public void setPriority(Integer priority) {
            this.priority = priority;
        }

        public String getProtocol() {
            return this.protocol;
        }

        public void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public String getEthertype() {
            return this.ethertype;
        }

        public void setEthertype(String ethertype) {
            this.ethertype = ethertype;
        }

        public String getDestCidrIp() {
            return this.destCidrIp;
        }

        public void setDestCidrIp(String destCidrIp) {
            this.destCidrIp = destCidrIp;
        }

        public String getRange() {
            return this.range;
        }

        public void setRange(String range) {
            this.range = range;
        }
    }

    public static class SgRulePreCheckRequest {
        @JsonProperty(value="regionID")
        private String regionID;
        @JsonProperty(value="securityGroupID")
        private String securityGroupID;
        @JsonProperty(value="securityGroupRule")
        private SgRulePreCheckSecurityGroupRuleRequest securityGroupRule;

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }

        public String getSecurityGroupID() {
            return this.securityGroupID;
        }

        public void setSecurityGroupID(String securityGroupID) {
            this.securityGroupID = securityGroupID;
        }

        public SgRulePreCheckSecurityGroupRuleRequest getSecurityGroupRule() {
            return this.securityGroupRule;
        }

        public void setSecurityGroupRule(SgRulePreCheckSecurityGroupRuleRequest securityGroupRule) {
            this.securityGroupRule = securityGroupRule;
        }
    }
}

