/*
 * Decompiled with CFR 0.152.
 */
package cn.ctyun.apis;

import cn.ctyun.sdk.Credential;
import cn.ctyun.sdk.CtyunClient;
import cn.ctyun.sdk.CtyunRequest;
import cn.ctyun.sdk.CtyunRequestBuilder;
import cn.ctyun.sdk.CtyunRequestException;
import cn.ctyun.sdk.CtyunRequestTemplate;
import cn.ctyun.sdk.CtyunResponse;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public class CtvpcListVpcApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CtvpcListVpcApi(CtyunClient client) {
        this.client = client;
        this.template = new CtyunRequestTemplate("ctvpc", "GET", "/v4/vpc/list", "application/json");
    }

    public ListVpcResponse send(Credential credential, ListVpcRequest request) throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(this.template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionID != null) {
            ctReq.addParam("regionID", request.regionID);
            request.regionID = null;
        }
        if (request.projectID != null) {
            ctReq.addParam("projectID", request.projectID);
            request.projectID = null;
        }
        if (request.vpcID != null) {
            ctReq.addParam("vpcID", request.vpcID);
            request.vpcID = null;
        }
        if (request.vpcName != null) {
            ctReq.addParam("vpcName", request.vpcName);
            request.vpcName = null;
        }
        if (request.pageNumber != null) {
            ctReq.addParam("pageNumber", String.valueOf(request.pageNumber));
            request.pageNumber = null;
        }
        if (request.pageNo != null) {
            ctReq.addParam("pageNo", String.valueOf(request.pageNo));
            request.pageNo = null;
        }
        if (request.pageSize != null) {
            ctReq.addParam("pageSize", String.valueOf(request.pageSize));
            request.pageSize = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(ListVpcResponse.class);
    }

    public static class ListVpcReturnObjVpcsResponse {
        @JsonProperty(value="vpcID")
        private String vpcID;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="CIDR")
        private String cIDR;
        @JsonProperty(value="ipv6Enabled")
        private Boolean ipv6Enabled;
        @JsonProperty(value="enableIpv6")
        private Boolean enableIpv6;
        @JsonProperty(value="ipv6CIDRS")
        private List<String> ipv6CIDRS;
        @JsonProperty(value="subnetIDs")
        private List<String> subnetIDs;
        @JsonProperty(value="natGatewayIDs")
        private List<String> natGatewayIDs;
        @JsonProperty(value="secondaryCIDRS")
        private List<String> secondaryCIDRS;
        @JsonProperty(value="projectID")
        private String projectID;
        @JsonProperty(value="dhcpOptionsSetID")
        private String dhcpOptionsSetID;
        @JsonProperty(value="vni")
        private Integer vni;
        @JsonProperty(value="createdAt")
        private String createdAt;
        @JsonProperty(value="updatedAt")
        private String updatedAt;
        @JsonProperty(value="dnsHostnamesEnabled")
        private Integer dnsHostnamesEnabled;

        public String getVpcID() {
            return this.vpcID;
        }

        public void setVpcID(String vpcID) {
            this.vpcID = vpcID;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getCIDR() {
            return this.cIDR;
        }

        public void setCIDR(String cIDR) {
            this.cIDR = cIDR;
        }

        public Boolean getIpv6Enabled() {
            return this.ipv6Enabled;
        }

        public void setIpv6Enabled(Boolean ipv6Enabled) {
            this.ipv6Enabled = ipv6Enabled;
        }

        public Boolean getEnableIpv6() {
            return this.enableIpv6;
        }

        public void setEnableIpv6(Boolean enableIpv6) {
            this.enableIpv6 = enableIpv6;
        }

        public List<String> getIpv6CIDRS() {
            return this.ipv6CIDRS;
        }

        public void setIpv6CIDRS(List<String> ipv6CIDRS) {
            this.ipv6CIDRS = ipv6CIDRS;
        }

        public List<String> getSubnetIDs() {
            return this.subnetIDs;
        }

        public void setSubnetIDs(List<String> subnetIDs) {
            this.subnetIDs = subnetIDs;
        }

        public List<String> getNatGatewayIDs() {
            return this.natGatewayIDs;
        }

        public void setNatGatewayIDs(List<String> natGatewayIDs) {
            this.natGatewayIDs = natGatewayIDs;
        }

        public List<String> getSecondaryCIDRS() {
            return this.secondaryCIDRS;
        }

        public void setSecondaryCIDRS(List<String> secondaryCIDRS) {
            this.secondaryCIDRS = secondaryCIDRS;
        }

        public String getProjectID() {
            return this.projectID;
        }

        public void setProjectID(String projectID) {
            this.projectID = projectID;
        }

        public String getDhcpOptionsSetID() {
            return this.dhcpOptionsSetID;
        }

        public void setDhcpOptionsSetID(String dhcpOptionsSetID) {
            this.dhcpOptionsSetID = dhcpOptionsSetID;
        }

        public Integer getVni() {
            return this.vni;
        }

        public void setVni(Integer vni) {
            this.vni = vni;
        }

        public String getCreatedAt() {
            return this.createdAt;
        }

        public void setCreatedAt(String createdAt) {
            this.createdAt = createdAt;
        }

        public String getUpdatedAt() {
            return this.updatedAt;
        }

        public void setUpdatedAt(String updatedAt) {
            this.updatedAt = updatedAt;
        }

        public Integer getDnsHostnamesEnabled() {
            return this.dnsHostnamesEnabled;
        }

        public void setDnsHostnamesEnabled(Integer dnsHostnamesEnabled) {
            this.dnsHostnamesEnabled = dnsHostnamesEnabled;
        }
    }

    public static class ListVpcReturnObjResponse {
        @JsonProperty(value="vpcs")
        private List<ListVpcReturnObjVpcsResponse> vpcs;

        public List<ListVpcReturnObjVpcsResponse> getVpcs() {
            return this.vpcs;
        }

        public void setVpcs(List<ListVpcReturnObjVpcsResponse> vpcs) {
            this.vpcs = vpcs;
        }
    }

    public static class ListVpcResponse {
        @JsonProperty(value="statusCode")
        private Integer statusCode;
        @JsonProperty(value="message")
        private String message;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="errorCode")
        private String errorCode;
        @JsonProperty(value="returnObj")
        private ListVpcReturnObjResponse returnObj;
        @JsonProperty(value="totalCount")
        private Integer totalCount;
        @JsonProperty(value="currentCount")
        private Integer currentCount;
        @JsonProperty(value="totalPage")
        private Integer totalPage;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public ListVpcReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(ListVpcReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public Integer getTotalCount() {
            return this.totalCount;
        }

        public void setTotalCount(Integer totalCount) {
            this.totalCount = totalCount;
        }

        public Integer getCurrentCount() {
            return this.currentCount;
        }

        public void setCurrentCount(Integer currentCount) {
            this.currentCount = currentCount;
        }

        public Integer getTotalPage() {
            return this.totalPage;
        }

        public void setTotalPage(Integer totalPage) {
            this.totalPage = totalPage;
        }
    }

    public static class ListVpcRequest {
        @JsonProperty(value="regionID")
        private String regionID;
        @JsonProperty(value="projectID")
        private String projectID;
        @JsonProperty(value="vpcID")
        private String vpcID;
        @JsonProperty(value="vpcName")
        private String vpcName;
        @JsonProperty(value="pageNumber")
        private Integer pageNumber;
        @JsonProperty(value="pageNo")
        private Integer pageNo;
        @JsonProperty(value="pageSize")
        private Integer pageSize;

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }

        public String getProjectID() {
            return this.projectID;
        }

        public void setProjectID(String projectID) {
            this.projectID = projectID;
        }

        public String getVpcID() {
            return this.vpcID;
        }

        public void setVpcID(String vpcID) {
            this.vpcID = vpcID;
        }

        public String getVpcName() {
            return this.vpcName;
        }

        public void setVpcName(String vpcName) {
            this.vpcName = vpcName;
        }

        public Integer getPageNumber() {
            return this.pageNumber;
        }

        public void setPageNumber(Integer pageNumber) {
            this.pageNumber = pageNumber;
        }

        public Integer getPageNo() {
            return this.pageNo;
        }

        public void setPageNo(Integer pageNo) {
            this.pageNo = pageNo;
        }

        public Integer getPageSize() {
            return this.pageSize;
        }

        public void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }
    }
}

