/*
 * Decompiled with CFR 0.152.
 */
package cn.ctyun.apis;

import cn.ctyun.sdk.Credential;
import cn.ctyun.sdk.CtyunClient;
import cn.ctyun.sdk.CtyunRequest;
import cn.ctyun.sdk.CtyunRequestBuilder;
import cn.ctyun.sdk.CtyunRequestException;
import cn.ctyun.sdk.CtyunRequestTemplate;
import cn.ctyun.sdk.CtyunResponse;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public class CtvpcListSubnetUsedIPsApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CtvpcListSubnetUsedIPsApi(CtyunClient client) {
        this.client = client;
        this.template = new CtyunRequestTemplate("ctvpc", "GET", "/v4/vpc/list-used-ips", "application/json");
    }

    public ListSubnetUsedIPsResponse send(Credential credential, ListSubnetUsedIPsRequest request) throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(this.template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionID != null) {
            ctReq.addParam("regionID", request.regionID);
            request.regionID = null;
        }
        if (request.subnetID != null) {
            ctReq.addParam("subnetID", request.subnetID);
            request.subnetID = null;
        }
        if (request.ip != null) {
            ctReq.addParam("ip", request.ip);
            request.ip = null;
        }
        if (request.pageNumber != null) {
            ctReq.addParam("pageNumber", String.valueOf(request.pageNumber));
            request.pageNumber = null;
        }
        if (request.pageNo != null) {
            ctReq.addParam("pageNo", String.valueOf(request.pageNo));
            request.pageNo = null;
        }
        if (request.pageSize != null) {
            ctReq.addParam("pageSize", String.valueOf(request.pageSize));
            request.pageSize = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(ListSubnetUsedIPsResponse.class);
    }

    public static class ListSubnetUsedIPsReturnObjUsedIPsResponse {
        @JsonProperty(value="ipv4Address")
        private String ipv4Address;
        @JsonProperty(value="ipv6Address")
        private String ipv6Address;
        @JsonProperty(value="useDesc")
        private String useDesc;
        @JsonProperty(value="use")
        private String use;
        @JsonProperty(value="secondaryPrivateIpv4")
        private List<String> secondaryPrivateIpv4;
        @JsonProperty(value="secondaryPrivateIpv6")
        private List<String> secondaryPrivateIpv6;

        public String getIpv4Address() {
            return this.ipv4Address;
        }

        public void setIpv4Address(String ipv4Address) {
            this.ipv4Address = ipv4Address;
        }

        public String getIpv6Address() {
            return this.ipv6Address;
        }

        public void setIpv6Address(String ipv6Address) {
            this.ipv6Address = ipv6Address;
        }

        public String getUseDesc() {
            return this.useDesc;
        }

        public void setUseDesc(String useDesc) {
            this.useDesc = useDesc;
        }

        public String getUse() {
            return this.use;
        }

        public void setUse(String use) {
            this.use = use;
        }

        public List<String> getSecondaryPrivateIpv4() {
            return this.secondaryPrivateIpv4;
        }

        public void setSecondaryPrivateIpv4(List<String> secondaryPrivateIpv4) {
            this.secondaryPrivateIpv4 = secondaryPrivateIpv4;
        }

        public List<String> getSecondaryPrivateIpv6() {
            return this.secondaryPrivateIpv6;
        }

        public void setSecondaryPrivateIpv6(List<String> secondaryPrivateIpv6) {
            this.secondaryPrivateIpv6 = secondaryPrivateIpv6;
        }
    }

    public static class ListSubnetUsedIPsReturnObjResponse {
        @JsonProperty(value="usedIPs")
        private List<ListSubnetUsedIPsReturnObjUsedIPsResponse> usedIPs;
        @JsonProperty(value="totalCount")
        private Integer totalCount;
        @JsonProperty(value="currentCount")
        private Integer currentCount;
        @JsonProperty(value="totalPage")
        private Integer totalPage;

        public List<ListSubnetUsedIPsReturnObjUsedIPsResponse> getUsedIPs() {
            return this.usedIPs;
        }

        public void setUsedIPs(List<ListSubnetUsedIPsReturnObjUsedIPsResponse> usedIPs) {
            this.usedIPs = usedIPs;
        }

        public Integer getTotalCount() {
            return this.totalCount;
        }

        public void setTotalCount(Integer totalCount) {
            this.totalCount = totalCount;
        }

        public Integer getCurrentCount() {
            return this.currentCount;
        }

        public void setCurrentCount(Integer currentCount) {
            this.currentCount = currentCount;
        }

        public Integer getTotalPage() {
            return this.totalPage;
        }

        public void setTotalPage(Integer totalPage) {
            this.totalPage = totalPage;
        }
    }

    public static class ListSubnetUsedIPsResponse {
        @JsonProperty(value="statusCode")
        private Integer statusCode;
        @JsonProperty(value="message")
        private String message;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="errorCode")
        private String errorCode;
        @JsonProperty(value="returnObj")
        private ListSubnetUsedIPsReturnObjResponse returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public ListSubnetUsedIPsReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(ListSubnetUsedIPsReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class ListSubnetUsedIPsRequest {
        @JsonProperty(value="regionID")
        private String regionID;
        @JsonProperty(value="subnetID")
        private String subnetID;
        @JsonProperty(value="ip")
        private String ip;
        @JsonProperty(value="pageNumber")
        private Integer pageNumber;
        @JsonProperty(value="pageNo")
        private Integer pageNo;
        @JsonProperty(value="pageSize")
        private Integer pageSize;

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }

        public String getSubnetID() {
            return this.subnetID;
        }

        public void setSubnetID(String subnetID) {
            this.subnetID = subnetID;
        }

        public String getIp() {
            return this.ip;
        }

        public void setIp(String ip) {
            this.ip = ip;
        }

        public Integer getPageNumber() {
            return this.pageNumber;
        }

        public void setPageNumber(Integer pageNumber) {
            this.pageNumber = pageNumber;
        }

        public Integer getPageNo() {
            return this.pageNo;
        }

        public void setPageNo(Integer pageNo) {
            this.pageNo = pageNo;
        }

        public Integer getPageSize() {
            return this.pageSize;
        }

        public void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }
    }
}

