/*
 * Decompiled with CFR 0.152.
 */
package cn.ctyun.apis;

import cn.ctyun.sdk.Credential;
import cn.ctyun.sdk.CtyunClient;
import cn.ctyun.sdk.CtyunRequest;
import cn.ctyun.sdk.CtyunRequestBuilder;
import cn.ctyun.sdk.CtyunRequestException;
import cn.ctyun.sdk.CtyunRequestTemplate;
import cn.ctyun.sdk.CtyunResponse;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public class CtvpcListSubnetApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CtvpcListSubnetApi(CtyunClient client) {
        this.client = client;
        this.template = new CtyunRequestTemplate("ctvpc", "GET", "/v4/vpc/list-subnet", "application/json");
    }

    public ListSubnetResponse send(Credential credential, ListSubnetRequest request) throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(this.template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.clientToken != null) {
            ctReq.addParam("clientToken", request.clientToken);
            request.clientToken = null;
        }
        if (request.regionID != null) {
            ctReq.addParam("regionID", request.regionID);
            request.regionID = null;
        }
        if (request.vpcID != null) {
            ctReq.addParam("vpcID", request.vpcID);
            request.vpcID = null;
        }
        if (request.subnetID != null) {
            ctReq.addParam("subnetID", request.subnetID);
            request.subnetID = null;
        }
        if (request.pageNumber != null) {
            ctReq.addParam("pageNumber", String.valueOf(request.pageNumber));
            request.pageNumber = null;
        }
        if (request.pageNo != null) {
            ctReq.addParam("pageNo", String.valueOf(request.pageNo));
            request.pageNo = null;
        }
        if (request.pageSize != null) {
            ctReq.addParam("pageSize", String.valueOf(request.pageSize));
            request.pageSize = null;
        }
        if (request.maxToken != null) {
            ctReq.addParam("maxToken", request.maxToken);
            request.maxToken = null;
        }
        if (request.maxResults != null) {
            ctReq.addParam("maxResults", String.valueOf(request.maxResults));
            request.maxResults = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(ListSubnetResponse.class);
    }

    public static class ListSubnetReturnObjSubnetsResponse {
        @JsonProperty(value="subnetID")
        private String subnetID;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="vpcID")
        private String vpcID;
        @JsonProperty(value="availabilityZones")
        private List<String> availabilityZones;
        @JsonProperty(value="routeTableID")
        private String routeTableID;
        @JsonProperty(value="networkAclID")
        private String networkAclID;
        @JsonProperty(value="CIDR")
        private String cIDR;
        @JsonProperty(value="gatewayIP")
        private String gatewayIP;
        @JsonProperty(value="dhcpIP")
        private String dhcpIP;
        @JsonProperty(value="start")
        private String start;
        @JsonProperty(value="end")
        private String end;
        @JsonProperty(value="availableIPCount")
        private Integer availableIPCount;
        @JsonProperty(value="ipv6Enabled")
        private Integer ipv6Enabled;
        @JsonProperty(value="enableIpv6")
        private Boolean enableIpv6;
        @JsonProperty(value="ipv6CIDR")
        private String ipv6CIDR;
        @JsonProperty(value="ipv6Start")
        private String ipv6Start;
        @JsonProperty(value="ipv6End")
        private String ipv6End;
        @JsonProperty(value="ipv6GatewayIP")
        private String ipv6GatewayIP;
        @JsonProperty(value="dnsList")
        private List<String> dnsList;
        @JsonProperty(value="systemDnsList")
        private List<String> systemDnsList;
        @JsonProperty(value="ntpList")
        private List<String> ntpList;
        @JsonProperty(value="type")
        private Integer type;
        @JsonProperty(value="updateAt")
        private String updateAt;
        @JsonProperty(value="createAt")
        private String createAt;
        @JsonProperty(value="projectID")
        private String projectID;

        public String getSubnetID() {
            return this.subnetID;
        }

        public void setSubnetID(String subnetID) {
            this.subnetID = subnetID;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getVpcID() {
            return this.vpcID;
        }

        public void setVpcID(String vpcID) {
            this.vpcID = vpcID;
        }

        public List<String> getAvailabilityZones() {
            return this.availabilityZones;
        }

        public void setAvailabilityZones(List<String> availabilityZones) {
            this.availabilityZones = availabilityZones;
        }

        public String getRouteTableID() {
            return this.routeTableID;
        }

        public void setRouteTableID(String routeTableID) {
            this.routeTableID = routeTableID;
        }

        public String getNetworkAclID() {
            return this.networkAclID;
        }

        public void setNetworkAclID(String networkAclID) {
            this.networkAclID = networkAclID;
        }

        public String getCIDR() {
            return this.cIDR;
        }

        public void setCIDR(String cIDR) {
            this.cIDR = cIDR;
        }

        public String getGatewayIP() {
            return this.gatewayIP;
        }

        public void setGatewayIP(String gatewayIP) {
            this.gatewayIP = gatewayIP;
        }

        public String getDhcpIP() {
            return this.dhcpIP;
        }

        public void setDhcpIP(String dhcpIP) {
            this.dhcpIP = dhcpIP;
        }

        public String getStart() {
            return this.start;
        }

        public void setStart(String start) {
            this.start = start;
        }

        public String getEnd() {
            return this.end;
        }

        public void setEnd(String end) {
            this.end = end;
        }

        public Integer getAvailableIPCount() {
            return this.availableIPCount;
        }

        public void setAvailableIPCount(Integer availableIPCount) {
            this.availableIPCount = availableIPCount;
        }

        public Integer getIpv6Enabled() {
            return this.ipv6Enabled;
        }

        public void setIpv6Enabled(Integer ipv6Enabled) {
            this.ipv6Enabled = ipv6Enabled;
        }

        public Boolean getEnableIpv6() {
            return this.enableIpv6;
        }

        public void setEnableIpv6(Boolean enableIpv6) {
            this.enableIpv6 = enableIpv6;
        }

        public String getIpv6CIDR() {
            return this.ipv6CIDR;
        }

        public void setIpv6CIDR(String ipv6CIDR) {
            this.ipv6CIDR = ipv6CIDR;
        }

        public String getIpv6Start() {
            return this.ipv6Start;
        }

        public void setIpv6Start(String ipv6Start) {
            this.ipv6Start = ipv6Start;
        }

        public String getIpv6End() {
            return this.ipv6End;
        }

        public void setIpv6End(String ipv6End) {
            this.ipv6End = ipv6End;
        }

        public String getIpv6GatewayIP() {
            return this.ipv6GatewayIP;
        }

        public void setIpv6GatewayIP(String ipv6GatewayIP) {
            this.ipv6GatewayIP = ipv6GatewayIP;
        }

        public List<String> getDnsList() {
            return this.dnsList;
        }

        public void setDnsList(List<String> dnsList) {
            this.dnsList = dnsList;
        }

        public List<String> getSystemDnsList() {
            return this.systemDnsList;
        }

        public void setSystemDnsList(List<String> systemDnsList) {
            this.systemDnsList = systemDnsList;
        }

        public List<String> getNtpList() {
            return this.ntpList;
        }

        public void setNtpList(List<String> ntpList) {
            this.ntpList = ntpList;
        }

        public Integer getType() {
            return this.type;
        }

        public void setType(Integer type) {
            this.type = type;
        }

        public String getUpdateAt() {
            return this.updateAt;
        }

        public void setUpdateAt(String updateAt) {
            this.updateAt = updateAt;
        }

        public String getCreateAt() {
            return this.createAt;
        }

        public void setCreateAt(String createAt) {
            this.createAt = createAt;
        }

        public String getProjectID() {
            return this.projectID;
        }

        public void setProjectID(String projectID) {
            this.projectID = projectID;
        }
    }

    public static class ListSubnetReturnObjResponse {
        @JsonProperty(value="subnets")
        private List<ListSubnetReturnObjSubnetsResponse> subnets;

        public List<ListSubnetReturnObjSubnetsResponse> getSubnets() {
            return this.subnets;
        }

        public void setSubnets(List<ListSubnetReturnObjSubnetsResponse> subnets) {
            this.subnets = subnets;
        }
    }

    public static class ListSubnetResponse {
        @JsonProperty(value="statusCode")
        private Integer statusCode;
        @JsonProperty(value="message")
        private String message;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="errorCode")
        private String errorCode;
        @JsonProperty(value="returnObj")
        private ListSubnetReturnObjResponse returnObj;
        @JsonProperty(value="totalCount")
        private Integer totalCount;
        @JsonProperty(value="currentCount")
        private Integer currentCount;
        @JsonProperty(value="totalPage")
        private Integer totalPage;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public ListSubnetReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(ListSubnetReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public Integer getTotalCount() {
            return this.totalCount;
        }

        public void setTotalCount(Integer totalCount) {
            this.totalCount = totalCount;
        }

        public Integer getCurrentCount() {
            return this.currentCount;
        }

        public void setCurrentCount(Integer currentCount) {
            this.currentCount = currentCount;
        }

        public Integer getTotalPage() {
            return this.totalPage;
        }

        public void setTotalPage(Integer totalPage) {
            this.totalPage = totalPage;
        }
    }

    public static class ListSubnetRequest {
        @JsonProperty(value="clientToken")
        private String clientToken;
        @JsonProperty(value="regionID")
        private String regionID;
        @JsonProperty(value="vpcID")
        private String vpcID;
        @JsonProperty(value="subnetID")
        private String subnetID;
        @JsonProperty(value="pageNumber")
        private Integer pageNumber;
        @JsonProperty(value="pageNo")
        private Integer pageNo;
        @JsonProperty(value="pageSize")
        private Integer pageSize;
        @JsonProperty(value="maxToken")
        private String maxToken;
        @JsonProperty(value="maxResults")
        private Integer maxResults;

        public String getClientToken() {
            return this.clientToken;
        }

        public void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }

        public String getVpcID() {
            return this.vpcID;
        }

        public void setVpcID(String vpcID) {
            this.vpcID = vpcID;
        }

        public String getSubnetID() {
            return this.subnetID;
        }

        public void setSubnetID(String subnetID) {
            this.subnetID = subnetID;
        }

        public Integer getPageNumber() {
            return this.pageNumber;
        }

        public void setPageNumber(Integer pageNumber) {
            this.pageNumber = pageNumber;
        }

        public Integer getPageNo() {
            return this.pageNo;
        }

        public void setPageNo(Integer pageNo) {
            this.pageNo = pageNo;
        }

        public Integer getPageSize() {
            return this.pageSize;
        }

        public void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        public String getMaxToken() {
            return this.maxToken;
        }

        public void setMaxToken(String maxToken) {
            this.maxToken = maxToken;
        }

        public Integer getMaxResults() {
            return this.maxResults;
        }

        public void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }
    }
}

