/*
 * Decompiled with CFR 0.152.
 */
package cn.ctyun.apis;

import cn.ctyun.sdk.Credential;
import cn.ctyun.sdk.CtyunClient;
import cn.ctyun.sdk.CtyunRequest;
import cn.ctyun.sdk.CtyunRequestBuilder;
import cn.ctyun.sdk.CtyunRequestException;
import cn.ctyun.sdk.CtyunRequestTemplate;
import cn.ctyun.sdk.CtyunResponse;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public class CtvpcListRouteTableRulesApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CtvpcListRouteTableRulesApi(CtyunClient client) {
        this.client = client;
        this.template = new CtyunRequestTemplate("ctvpc", "GET", "/v4/vpc/route-table/list-rules", "application/json");
    }

    public ListRouteTableRulesResponse send(Credential credential, ListRouteTableRulesRequest request) throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(this.template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionID != null) {
            ctReq.addParam("regionID", request.regionID);
            request.regionID = null;
        }
        if (request.routeTableID != null) {
            ctReq.addParam("routeTableID", request.routeTableID);
            request.routeTableID = null;
        }
        if (request.pageNumber != null) {
            ctReq.addParam("pageNumber", String.valueOf(request.pageNumber));
            request.pageNumber = null;
        }
        if (request.pageNo != null) {
            ctReq.addParam("pageNo", String.valueOf(request.pageNo));
            request.pageNo = null;
        }
        if (request.pageSize != null) {
            ctReq.addParam("pageSize", String.valueOf(request.pageSize));
            request.pageSize = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(ListRouteTableRulesResponse.class);
    }

    public static class ListRouteTableRulesReturnObjResponse {
        @JsonProperty(value="nextHopID")
        private String nextHopID;
        @JsonProperty(value="nextHopType")
        private String nextHopType;
        @JsonProperty(value="destination")
        private String destination;
        @JsonProperty(value="ipVersion")
        private Integer ipVersion;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="routeRuleID")
        private String routeRuleID;

        public String getNextHopID() {
            return this.nextHopID;
        }

        public void setNextHopID(String nextHopID) {
            this.nextHopID = nextHopID;
        }

        public String getNextHopType() {
            return this.nextHopType;
        }

        public void setNextHopType(String nextHopType) {
            this.nextHopType = nextHopType;
        }

        public String getDestination() {
            return this.destination;
        }

        public void setDestination(String destination) {
            this.destination = destination;
        }

        public Integer getIpVersion() {
            return this.ipVersion;
        }

        public void setIpVersion(Integer ipVersion) {
            this.ipVersion = ipVersion;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getRouteRuleID() {
            return this.routeRuleID;
        }

        public void setRouteRuleID(String routeRuleID) {
            this.routeRuleID = routeRuleID;
        }
    }

    public static class ListRouteTableRulesResponse {
        @JsonProperty(value="statusCode")
        private Integer statusCode;
        @JsonProperty(value="message")
        private String message;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="errorCode")
        private String errorCode;
        @JsonProperty(value="totalCount")
        private Integer totalCount;
        @JsonProperty(value="currentCount")
        private Integer currentCount;
        @JsonProperty(value="totalPage")
        private Integer totalPage;
        @JsonProperty(value="returnObj")
        private List<ListRouteTableRulesReturnObjResponse> returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public Integer getTotalCount() {
            return this.totalCount;
        }

        public void setTotalCount(Integer totalCount) {
            this.totalCount = totalCount;
        }

        public Integer getCurrentCount() {
            return this.currentCount;
        }

        public void setCurrentCount(Integer currentCount) {
            this.currentCount = currentCount;
        }

        public Integer getTotalPage() {
            return this.totalPage;
        }

        public void setTotalPage(Integer totalPage) {
            this.totalPage = totalPage;
        }

        public List<ListRouteTableRulesReturnObjResponse> getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(List<ListRouteTableRulesReturnObjResponse> returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class ListRouteTableRulesRequest {
        @JsonProperty(value="regionID")
        private String regionID;
        @JsonProperty(value="routeTableID")
        private String routeTableID;
        @JsonProperty(value="pageNumber")
        private Integer pageNumber;
        @JsonProperty(value="pageNo")
        private Integer pageNo;
        @JsonProperty(value="pageSize")
        private Integer pageSize;

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }

        public String getRouteTableID() {
            return this.routeTableID;
        }

        public void setRouteTableID(String routeTableID) {
            this.routeTableID = routeTableID;
        }

        public Integer getPageNumber() {
            return this.pageNumber;
        }

        public void setPageNumber(Integer pageNumber) {
            this.pageNumber = pageNumber;
        }

        public Integer getPageNo() {
            return this.pageNo;
        }

        public void setPageNo(Integer pageNo) {
            this.pageNo = pageNo;
        }

        public Integer getPageSize() {
            return this.pageSize;
        }

        public void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }
    }
}

